<?php  
include("auth.php");
include("../config.php");

$gallery = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM gallery WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $gallery = $result->fetch_assoc();
    } else {
        echo "Image/Video not found.";
        exit;
    }

    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Gallery <?php echo isset($_GET['id']) ? 'Edit' : 'Add'; ?> - <?php echo $settings['site_name']; ?></title>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1><?php echo isset($_GET['id']) ? 'Edit' : 'Add'; ?> Gallery</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">Gallery</li>
        </ol>
      </nav>
    </div>

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="gallery.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Back to Gallery</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Gallery Details</h5>
              
              <form class="row g-3" id="galleryform" enctype="multipart/form-data" method="POST" data-oldtype="<?php echo isset($gallery['type']) ? htmlspecialchars($gallery['type']) : ''; ?>">
                
                <!-- Type -->
                <div class="col-md-6">
                  <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
                  <select class="form-select" id="type" name="type" required>
                    <option value="">Select Type</option>
                    <option value="Image" <?php if(isset($gallery['type']) && $gallery['type']=='Image') echo 'selected'; ?>>Image</option>
                    <option value="Video" <?php if(isset($gallery['type']) && $gallery['type']=='Video') echo 'selected'; ?>>Video</option>
                  </select>
                </div>

                <!-- Tag -->
                <div class="col-md-6">
                  <label for="tag" class="form-label">Tag <span class="text-danger">*</span></label>
                  <input type="text" class="form-control" id="tag" name="tag" 
                         value="<?php echo isset($gallery['tag']) ? htmlspecialchars($gallery['tag']) : ''; ?>" 
                         placeholder="Enter tag (e.g. Event, Celebration)" required>
                </div>

                <!-- Image Upload -->
                <div class="col-md-12" id="imageUploadDiv" style="display: none;">
                  <label for="image" class="form-label">Upload Image</label>
                  <?php if (isset($_GET['id']) && $gallery['type'] == 'Image' && !empty($gallery['image_path'])): ?>
                    <div class="input-group">
                      <input type="file" class="form-control" id="image" name="image">
                      <input type="hidden" name="old_file" value="<?php echo htmlspecialchars($gallery['image_path']); ?>">
                      <a href="./<?php echo htmlspecialchars($gallery['image_path']); ?>" target="_blank" class="btn btn-outline-primary">
                        <i class="bi bi-eye"></i> View
                      </a>
                    </div>
                    <small class="text-muted">Upload a new image to replace the existing one.</small>
                  <?php else: ?>
                    <input type="file" class="form-control" id="image" name="image">
                  <?php endif; ?>
                </div>

                <!-- Video Link -->
                <div class="col-md-12" id="videoLinkDiv" style="display: none;">
                  <label for="video_link" class="form-label">Video Link (YouTube / Vimeo)</label>
                  <input type="url" class="form-control" id="video_link" name="video_link"
                         value="<?php echo isset($gallery['image_path']) ? htmlspecialchars($gallery['image_path']) : ''; ?>"
                         placeholder="Paste video link here">
                </div>

                <div id="msg"></div>

                <div class="col-md-12">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    <?php if(isset($_GET['id'])) { ?>
                      <input type="hidden" name="id" id="id" value="<?php echo $id; ?>">
                      <input type="hidden" name="action" id="action" value="Edit">
                      <button class="btn btn-success" type="submit">Update</button>
                      <a href="gallery.php" class="btn btn-secondary">Cancel</a>
                    <?php } else { ?>
                      <input type="hidden" name="action" id="action" value="Add">
                      <button class="btn btn-success" type="submit">Submit</button>
                      <button class="btn btn-secondary" type="reset">Reset</button>
                    <?php } ?>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  </main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/js/main.js"></script>
  <script src="./scripts/gallery.js"></script>


</body>
</html>
