<?php
include("../config.php");

if (!isset($_GET['eid'])) {
    echo json_encode(['status' => 'error']);
    exit;
}

$eid = intval($_GET['eid']);

// 1. Get course fee details
$q1 = mysqli_query($conn, "
    SELECT e.fee_status, e.cid, c.fees, c.discount 
    FROM enrolments e
    JOIN course c ON c.id = e.cid
    WHERE e.enrolment_id = $eid
");

$data = mysqli_fetch_assoc($q1);

$total_fee = $data['fees'] - $data['discount'];

// 2. Get total paid amount
$q2 = mysqli_query($conn, "
    SELECT SUM(payment_amount) AS paid 
    FROM fees_receipts 
    WHERE enrolment_id = $eid AND deleted_at IS NULL AND payment_status='Paid'
");
$paidRow = mysqli_fetch_assoc($q2);

$paid = $paidRow['paid'] ?? 0;

// 3. Remaining amount
$remaining = $total_fee - $paid;

// Convert database fee_status to readable labels
$display_fee_status = "";

if ($data['fee_status'] == "Paid") {
    $display_fee_status = "Paid";
} elseif ($data['fee_status'] == "Pending") {
    $display_fee_status = "Unpaid";
} elseif ($data['fee_status'] == "Partial") {
    $display_fee_status = "Partially Paid";
}

// Return JSON
echo json_encode([
    "status" => "success",
    "fee_status" => $display_fee_status,
    "total_fee" => $total_fee,
    "paid" => $paid,
    "remaining" => $remaining
]);

