<?php
require_once '../config.php'; // adjust path as needed

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $enquiry_id = intval($_POST['enquiry_id']);

    $query = "SELECT f.followup_id, f.followup_date, f.next_action_date, f.status, f.notes, 
                     u.name AS user_name 
              FROM followups f
              LEFT JOIN users u ON f.user_id = u.user_id
              WHERE f.enquiry_id = ? AND f.deleted_at is NULL 
              ORDER BY f.followup_date DESC";

    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $enquiry_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<table class='table table-bordered table-sm'>
                <thead class='table-light'>
                  <tr>
                    <th>Date</th>
                    <th>Next Action Date</th>
                    <th>Status</th>
                    <th>Notes</th>
                    <th>Updated By</th>
                  </tr>
                </thead>
                <tbody>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>".htmlspecialchars($row['followup_date'])."</td>
                    <td>".htmlspecialchars($row['next_action_date'] ?: '-')."</td>
                    <td>".htmlspecialchars($row['status'])."</td>
                    <td>".nl2br(htmlspecialchars($row['notes']))."</td>
                    <td>".htmlspecialchars($row['user_name'] ?: 'N/A')."</td>
                  </tr>";
        }
        echo "</tbody></table>";
    } else {
        echo "<p class='text-muted'>No follow-up history found for this enquiry.</p>";
    }
} else {
    echo "<div class='alert alert-danger'>Invalid request method.</div>";
}
?>
