<?php
require "../config.php";
if (session_status() === PHP_SESSION_NONE) session_start();

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Security headers
if (ob_get_length()) ob_clean();
header("Content-Type: application/json");
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

if (!empty($_POST['email']) && !empty($_POST['password'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    // CAPTCHA check
    if (!isset($_POST['captcha']) || strtolower($_POST['captcha']) !== strtolower($_SESSION['captcha_text'])) {
        exit(json_encode(["status"=>"error","message"=>"CAPTCHA incorrect"]));
    }

    unset($_SESSION['captcha_text']); // remove captcha text after validation

    // Fetch user
    $stmt = $conn->prepare("SELECT * FROM users WHERE email=? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {

        // Soft-deleted check
        if (!is_null($user['deleted_at'])) {
            exit(json_encode(["status" => "error", "message" => "Account does not exist."]));
        }

        // ✅ Active status check
        if (strtolower($user['status']) !== 'active') {
            exit(json_encode(["status" => "error", "message" => "Your account is deactivated. Please contact the administrator."]));
        }

        // Brute force lockout
        if ($user['failed_attempts'] >= 5 && strtotime($user['last_failed']) > strtotime("-15 minutes")) {
            exit(json_encode(["status" => "error", "message" => "Too many failed attempts. Try again later."]));
        }

        // Password check
        if (password_verify($password, $user['password'])) {
            // Reset failed attempts
            $conn->query("UPDATE users SET failed_attempts=0 WHERE user_id=" . intval($user['user_id']));

            // Secure session setup
            session_regenerate_id(true);
            $_SESSION['user_id'] = $user['user_id'];
            $_SESSION['name'] = htmlspecialchars($user['name'], ENT_QUOTES, 'UTF-8');
            $_SESSION['email'] = $user['email'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['status'] = $user['status'];
            $_SESSION['created_time'] = time();
            $_SESSION['last_activity'] = time(); 
            
            exit(json_encode(["status" => "success", "message" => "Login successful"]));
        } else {
            // Wrong password
            $conn->query("UPDATE users 
                          SET failed_attempts = failed_attempts + 1, last_failed = NOW() 
                          WHERE user_id=" . intval($user['user_id']));
            exit(json_encode(["status" => "error", "message" => "Invalid credentials."]));
        }

    } else {
        // No such user
        exit(json_encode(["status" => "error", "message" => "Invalid credentials."]));
    }

} else {
    exit(json_encode(["status" => "error", "message" => "Missing email or password."]));
}
?>

