<?php
include("auth.php");
include("../config.php");

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Something went wrong.'];


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action']; // Either 'Add' or 'Edit'
    $id = $_POST['id'] ?? null; // If it's an edit, id will be provided
    $mediaTitle = $_POST['media_title'];
    $mediaType = $_POST['type'];
    $mediaUrl = $_POST['media_url'] ?? '';

    // Check if it's an edit or add action
    // EDIT mode
if ($action === 'Edit' && !empty($id)) {

    // Fetch existing media
    $stmt = $conn->prepare("SELECT media_url, type FROM media WHERE media_id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $existing = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    $existingType = $existing['type'];
    $existingUrl  = $existing['media_url'];

    // ✅ CASE 1: New type is Link/Video → no file upload required
    if ($mediaType === 'Links' || $mediaType === 'Video') {
        $mediaUrl = $_POST['media_url'];
    }

    // ✅ CASE 2: New type is Image/PDF
    elseif ($mediaType === 'Image' || $mediaType === 'PDF') {

        // ✅ If existing type was also Image/PDF
        if ($existingType === $mediaType) {

            // ✅ No type change → keep old file if no new upload
            if (!empty($_FILES['media_url']['name'])) {
                $upload = handleFileUpload($mediaType);
                if (!$upload['success']) {
                    echo json_encode($upload);
                    exit;
                }
                $mediaUrl = $upload['media_url'];
            } else {
                // ✅ Keep old image/PDF
                $mediaUrl = $existingUrl;
            }
        }

        // ✅ CASE 3: Changing between Image ↔ PDF → require new file
        elseif ($existingType !== $mediaType) {

            if (empty($_FILES['media_url']['name'])) {
                echo json_encode([
                    'success' => false,
                    'message' => "Please upload a new file when changing media type."
                ]);
                exit;
            }

            $upload = handleFileUpload($mediaType);
            if (!$upload['success']) {
                echo json_encode($upload);
                exit;
            }
            $mediaUrl = $upload['media_url'];
        }

        // ✅ CASE 4: Previous type was Link/Video → now Image/PDF → require file
        elseif ($existingType === 'Links' || $existingType === 'Video') {

            if (empty($_FILES['media_url']['name'])) {
                echo json_encode([
                    'success' => false,
                    'message' => "Please upload a file for Image/PDF type."
                ]);
                exit;
            }

            $upload = handleFileUpload($mediaType);
            if (!$upload['success']) {
                echo json_encode($upload);
                exit;
            }

            $mediaUrl = $upload['media_url'];
        }
    }
}
 else if ($action === 'Add') {
        // Add case: handle the file upload if required
        $uploadResult = handleFileUpload($mediaType); // Pass media type for conditional upload
        if ($uploadResult['success']) {
            $mediaUrl = $uploadResult['media_url'];
        } else {
            $response['message'] = $uploadResult['message'];
            echo json_encode($response);
            exit;
        }
    }

    // Now insert or update in the database
    if ($action === 'Add') {
        $stmt = $conn->prepare("INSERT INTO media (media_title, type, media_url) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $mediaTitle, $mediaType, $mediaUrl);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media added successfully!', 'redirect' => 'medias.php'];
        } else {
            $response['message'] = 'Error adding media.';
        }
        $stmt->close();
    } else if ($action === 'Edit') {
        $stmt = $conn->prepare("UPDATE media SET media_title = ?, type = ?, media_url = ? WHERE media_id = ?");
        $stmt->bind_param("sssi", $mediaTitle, $mediaType, $mediaUrl, $id);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media updated successfully!', 'redirect' => 'medias.php'];
        } else {
            $response['message'] = 'Error updating media.';
        }
        $stmt->close();
    }
    else if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE media SET deleted_at = NOW() WHERE media_id = ?");
        $stmt->bind_param("i",  $id);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Media deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete media.';
        }

        $stmt->close();
    }
    echo json_encode($response);
}

// Handle file upload logic (for Add and Edit)
function handleFileUpload($mediaType) {
    $uploadDirectory = "../uploads/media_files/";
    $allowedFileTypes = ['image/jpeg', 'image/png', 'application/pdf', 'application/msword'];

    // Check if a file upload is required based on media type
    if ($mediaType === 'Video' || $mediaType === 'Links') {
        // For video or link, no file upload is needed, just return the text URL
        return ['success' => true, 'media_url' => $_POST['media_url']];
    }

    // Otherwise, proceed with file upload
    if (isset($_FILES['media_url']) && $_FILES['media_url']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['media_url'];
        $fileTmpName = $file['tmp_name'];
        $fileName = basename($file['name']);
        $fileSize = $file['size'];
        $fileType = $file['type'];

        // Check file type and size
        if (!in_array($fileType, $allowedFileTypes)) {
            return ['success' => false, 'message' => 'Invalid file type.'];
        }
        if ($fileSize > 5000000) { // 5MB limit
            return ['success' => false, 'message' => 'File is too large.'];
        }

        // Move the uploaded file to the desired directory
        $uploadPath = $uploadDirectory . $fileName;
        if (move_uploaded_file($fileTmpName, $uploadPath)) {
            return ['success' => true, 'media_url' => 'uploads/media_files/'.$fileName];
        } else {
            return ['success' => false, 'message' => 'Error uploading file.'];
        }
    }

    return ['success' => false, 'message' => 'No file uploaded.'];
}
?>




