<?php  include ("auth.php");
include ("../config.php");
// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Media - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Media</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Media</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            
          <?php if($_SESSION['role']== '') { ?>  
          <a href="media.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>
          <?php } ?>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Media List</h5>
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <!-- Table with stripped rows -->
              <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Media</th>
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Last Updated</th>
                    
                  </tr>
                </thead>
<tbody>
<?php
$sql = "SELECT * FROM `media` WHERE deleted_at is NULL order by media_title";
$result = mysqli_query($conn, $sql);
$sl=1;
if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
    echo "<tr>";
    echo "<td style='white-space: nowrap;'>".$sl."</td>";
         if($_SESSION['role']== '') 
    echo "<td style='white-space: nowrap;'>
            <a href='media.php?id=" . base64_encode($row['media_id']) . "' class='btn btn-sm btn-warning'><i class='bi bi-pen'></i></a>
            <button class='btn btn-sm btn-danger' onclick='deleteMedia(".$row['media_id'].")'>
             <i class='bi bi-trash'></i>
            </button>
          </td>";
      else
    echo "<td style='white-space: nowrap;'>
            <a href='media.php?id=" . base64_encode($row['media_id']) . "' class='btn btn-sm btn-warning'><i class='bi bi-pen'></i></a>
          </td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['media_title']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['type']) . "</td>";

  // Check the media type and display accordingly
  if ($row['type'] === 'Image') {
      // For Images, display the image tag
      echo "<td><img src='../" . htmlspecialchars($row['media_url']) . "' alt='Media Image' style='max-width:100px; max-height:100px;'></td>";
  } elseif ($row['type'] === 'Video') {
      // For Videos, embed a video tag
      echo "<td><a href='" . htmlspecialchars($row['media_url']) . "' target='_blank'>" . htmlspecialchars($row['media_url']) . "</a></td>";
  } elseif ($row['type'] === 'PDF') {
      // For PDFs, show a 'View PDF' link
      echo "<td><a href='../" . htmlspecialchars($row['media_url']) . "' target='_blank' class='btn btn-sm btn-info'>View PDF</a></td>";
  } elseif ($row['type'] === 'Links') {
      // For Links, show an anchor tag
      echo "<td><a href='" . htmlspecialchars($row['media_url']) . "' target='_blank'>" . htmlspecialchars($row['media_url']) . "</a></td>";
  } else {
      echo "<td>".$row['media_url']."</td>"; // In case the type is undefined or new
  }

    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at']) . "</td>";

    echo "</tr>";
    $sl++;
  }
} else {
  echo "<tr><td colspan='6' class='text-center'>No Media found.</td></tr>";
}
?>
</tbody>

              </table>
              </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/media.js"></script>

</body>
</html>