<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Unknown error'];

// Simple role check (optional, can restrict deletes/edits if needed)
$role = $_SESSION['role'] ?? '';

// Get POST parameters
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$notice = $_POST['notice'] ?? ''; 

// Sanitize content_title to remove HTML and scripts 
$notice = htmlspecialchars(strip_tags($notice), ENT_QUOTES, 'UTF-8');


// Validate that required fields are not empty
if (  $action!='Subscribed' && $action!='Unsubscribed'  ) {
    $response['message'] = 'Newsletter is empty.';
    echo json_encode($response);
    exit;
}



// === ACTIVATE / DEACTIVATE COURSE ===
if (($action === 'Subscribed' || $action === 'Unsubscribed') && $id > 0) {
    $newStatus = ($action === 'Subscribed') ? 'Subscribed' : 'Unsubscribed';
    try {
        $stmt = $conn->prepare("UPDATE newsletter SET status = ?, updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("si", $newStatus, $id);
        if ($stmt->execute()) {
            $response = [
                'success' => true,
                'message' => "Newsletter {$newStatus}d successfully."
            ];
        } else {
            $response['message'] = "Failed to {$action} newsletter.";
        }
        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    echo json_encode($response);
    $conn->close();
    exit;
}





// Return JSON response
echo json_encode($response);
$conn->close();
exit;
?>



