<?php  include ("auth.php");
include ("../config.php");
// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Notices - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Newsletters</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Newsletter</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            

          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Newsletter List</h5>
              
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <button class="btn btn-primary mb-3" id="sendBulkBtn">Send Bulk Email</button>

              <!-- Table with stripped rows -->
              <div class="table-responsive">
              <table class="table table">
                <thead>
                  <tr>
                    <th>#</th>
                    <th><input type="checkbox" id="select_all"></th>
                    <th>Action</th>
                    <th>Email</th>                    
                    <th>Status</th>                    
                    <th data-type="date" data-format="YYYY/DD/MM" style="white-space: nowrap;">Subscribed at</th>
                    
                  </tr>
                </thead>
<tbody>
<?php
$sql = "SELECT *  FROM `newsletter` WHERE deleted_at is NULL order by id desc";
$result = mysqli_query($conn, $sql);
$sl=1;
if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
    echo "<tr>";
    echo "<td style='white-space: nowrap;'>".$sl."</td>";
    echo "<td>";
if ($row['status'] === 'Subscribed') {
    echo "<input type='checkbox' class='row_checkbox' value='".$row['email']."'>";
}
echo "</td>";

    echo "<td style='white-space: nowrap;'>";
    
        if ($row['status'] === 'Subscribed') {
            echo "<button class='btn btn-sm btn-success' onclick='toggleNewsletterStatus(" . $row['id'] . ", \"Unsubscribed\")'>Unsubscribed</button>";
        } else {
            echo "<button class='btn btn-sm btn-danger' onclick='toggleNewsletterStatus(" . $row['id'] . ", \"Subscribed\")'>Subscribed</button>";
        }
    echo "</td>";

        

   
   
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['email']) . "</td>";
    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['status']) . "</td>";

    echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at']) . "</td>";
    
    echo "</tr>";
    $sl++;
  }
} else {
  echo "<tr><td colspan='4' class='text-center'>No newsletter found.</td></tr>";
}
?>
</tbody>

              </table>
              </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
<!-- Bulk Email Modal -->
<!-- Quill CSS -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

<!-- Bulk Email Modal -->
<div class="modal fade" id="bulkEmailModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      
      <div class="modal-header">
        <h5 class="modal-title">Send Bulk Newsletter</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        
        <label><strong>Subject</strong></label>
        <input type="text" id="newsletterSubject" class="form-control mb-3" placeholder="Enter Mail subject">

        <label><strong>Message</strong></label>

<!-- Toolbar -->
<div id="toolbar">
  
  <!-- Font Family -->
  <span class="ql-formats">
    <select class="ql-font"></select>
  </span>

  <!-- Font Size -->
  <span class="ql-formats">
    <select class="ql-size"></select>
  </span>

  <!-- Formatting -->
  <span class="ql-formats">
    <button class="ql-bold"></button>
    <button class="ql-italic"></button>
    <button class="ql-underline"></button>
  </span>

  <!-- Lists -->
  <span class="ql-formats">
    <button class="ql-list" value="ordered"></button>
    <button class="ql-list" value="bullet"></button>
  </span>

  <!-- Link -->
  <span class="ql-formats">
    <button class="ql-link"></button>
  </span>

</div>

<!-- Editor -->
<div id="editor" style="height:250px;"></div>


      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button class="btn btn-primary" id="saveNewsletterBtn">Send Newsletter</button>
      </div>

    </div>
  </div>
</div>




<!-- Quill JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>


  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/newsletter.js"></script>
<script>
// Select All
// Fix for DataTable (event delegation)
document.addEventListener("change", function(e) {
    if (e.target.id === "select_all") {
        document.querySelectorAll("input.row_checkbox").forEach(cb => {
            cb.checked = e.target.checked;
        });
    }
});
// Initialize simple Quill
var quill = new Quill('#editor', {
    theme: 'snow',
    placeholder: 'Type your message here...',
    modules: { toolbar: '#toolbar' }
});

// Track selected emails
let selectedEmails = [];

document.getElementById("sendBulkBtn").onclick = function() {
    selectedEmails = [];
    document.querySelectorAll(".row_checkbox:checked").forEach(cb => selectedEmails.push(cb.value));

    if (selectedEmails.length === 0) {
        alert("Please select at least one email!");
        return;
    }

    var modal = new bootstrap.Modal(document.getElementById("bulkEmailModal"));
    modal.show();
};


document.getElementById("saveNewsletterBtn").onclick = async function () {
    
    var modalEl = document.getElementById("bulkEmailModal");
    var modal = new bootstrap.Modal(modalEl, {
    backdrop: 'static',
    keyboard: false
    });


    const btn = document.getElementById("saveNewsletterBtn");
    const originalText = btn.innerHTML;

    // Disable button + show spinner
    btn.disabled = true;
    btn.innerHTML = `<span class="spinner-border spinner-border-sm me-2"></span>Sending...`;

    let subject = document.getElementById("newsletterSubject").value.trim();
    let message = quill.root.innerHTML.trim();

    if (subject === "" || message === "") {
        alert("Please enter subject and message.");
        btn.disabled = false;
        btn.innerHTML = originalText;
        return;
    }

    let selectedEmails = [];
    document.querySelectorAll(".row_checkbox:checked").forEach(cb =>
        selectedEmails.push(cb.value)
    );

    let formData = new FormData();
    formData.append("subject", subject);
    formData.append("message", message);
    formData.append("emails", JSON.stringify(selectedEmails));
    formData.append("csrf_token", "<?php echo $_SESSION['csrf_token']; ?>");

    let response = await fetch("send-newsletter-bulk.php", {
        method: "POST",
        body: formData
    });

    let text = await response.text();
    console.log(text);

    let res;
    try {
        res = JSON.parse(text);
    } catch (e) {
        alert("Server returned invalid JSON. Check console for details.");
        
        // Restore button
        btn.disabled = false;
        btn.innerHTML = originalText;
        return;
    }

    // Restore button before alert
    btn.disabled = false;
    btn.innerHTML = originalText;

    if (res.status === true) {
        alert("Successfully sent! " + res.sent + " sent, " + res.failed + " failed.");
        location.reload();
    } else {
        alert("Error: " + res.message);
    }
};


</script>

</body>

</html>