<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Unknown error'];

// Simple role check (optional, can restrict deletes/edits if needed)
$role = $_SESSION['role'] ?? '';

// Get POST parameters
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$notice = $_POST['notice'] ?? '';

// Sanitize content_title to remove HTML and scripts
$notice = htmlspecialchars(strip_tags($notice), ENT_QUOTES, 'UTF-8');

// Validate that required fields are not empty
if ($action!='delete' && $action!='Activate' && $action!='Deactivate' && (empty($notice)) ) {
    $response['message'] = 'Notice cannot be empty.';
    echo json_encode($response);
    exit;
}

// Handle the delete action via POST (AJAX)
if ($action === 'delete' && $id > 0) {
    try {
        // Prepare and execute the soft delete query
        $stmt = $conn->prepare("UPDATE notice SET deleted_at = NOW() WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Notice deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete notice.';
        }

        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    // Return JSON response after the delete action
    echo json_encode($response);
    $conn->close();
    exit;
}


// === ACTIVATE / DEACTIVATE COURSE ===
if (($action === 'Activate' || $action === 'Deactivate') && $id > 0) {
    $newStatus = ($action === 'Activate') ? 'Active' : 'Deactive';
    try {
        $stmt = $conn->prepare("UPDATE notice SET status = ?, updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("si", $newStatus, $id);
        if ($stmt->execute()) {
            $response = [
                'success' => true,
                'message' => "Notice {$newStatus}d successfully."
            ];
        } else {
            $response['message'] = "Failed to {$action} notice.";
        }
        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    echo json_encode($response);
    $conn->close();
    exit;
}



// For Add and Edit actions
try {
    if ($action === 'Add') {
        // Insert new content
        $stmt = $conn->prepare("INSERT INTO notice (notice) VALUES (?)");
        $stmt->bind_param("s", $notice);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Notice added successfully', 'redirect' => 'notices.php'];
        } else {
            $response['message'] = 'Failed to add notice';
        }

        $stmt->close();

    } elseif ($action === 'Edit' && $id > 0) {
        // Edit existing content
        $stmt = $conn->prepare("UPDATE notice SET notice=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param("si", $notice, $id);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Notice updated successfully', 'redirect' => 'notices.php'];
        } else {
            $response['message'] = 'Failed to update notice';
        }

        $stmt->close();

    } else {
        $response['message'] = 'Invalid action or missing notice ID';
    }

} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

// Return JSON response
echo json_encode($response);
$conn->close();
exit;
?>



