<?php  include ("auth.php");
include ("../config.php");

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>QR Codes - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
  <style>
.qr-print-area {
    width: 210mm;
    height: 297mm;
    padding: 20mm;
    background: #fff;
    text-align: center;
    border: 1px solid #ddd;
    position: relative;
}

.qr-box {
    margin-top: 20px;
    padding: 15px;
    border: 2px solid #000;
    display: inline-block;
    background: #fff;
}

.company-logo {
    width: 300px;
    margin-bottom: 10px;
}

.standee-upi-box {
    border: 3px solid #0056ff;
    padding: 20px;
    border-radius: 12px;
    background: #f8faff;
    display: inline-block;
    margin-top: 20px;
}

.standee-title {
    font-size: 24px;
    font-weight: bold;
    margin-top: 10px;
    color: #0047d4;
}

.standee-pay-text {
    font-size: 18px;
    margin-top: 20px;
    color: #333;
}

.print-btn {
    margin-top: 20px;
}
/* ✅ Custom margins */
.margin-top-large { margin-top: 40px !important; }
.margin-top-medium { margin-top: 20px !important; }
.margin-bottom-large { margin-bottom: 40px !important; }
.margin-bottom-medium { margin-bottom: 20px !important; }

/* ✅ Custom font sizes */
.text-large { font-size: 20px !important; }
.text-medium { font-size: 18px !important; }
.text-heading { font-size: 26px !important; font-weight: bold; }

/* ✅ Paragraph styling */
.para-margin { margin-top: 35px !important; margin-bottom: 20px !important; }

/* ✅ QR container styling */
.qr-box {
    margin-top: 20px !important;
}

/* ✅ Printing layout fix */
@media print {

    body {
        visibility: hidden;
        margin: 0;
        padding: 0;
    }

    .print-area {
        visibility: visible;
        position: relative;
        margin: 0 auto;
        width: 210mm;
        min-height: 297mm;
        padding: 20mm;
        text-align: center;
        box-sizing: border-box;
        display: block;
    }

    @page {
        size: A4;
        margin: 0;
    }
}

.standee-container {
    width: 101.6mm;          /* 4 inches */
    height: 152.4mm;         /* 6 inches */
    background: #e9f1ff;     /* light blue or any color */
    border-radius: 10px;
    padding: 10px;
    box-sizing: border-box;
    text-align: center;
    margin: 0 auto;
}


</style>
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>QR Codes</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">QR Codes</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            <div class="card">
  <div class="card-body">

    <h5 class="card-title">QR Codes</h5>

    <!--Tabs Navigation-->
    <ul class="nav nav-tabs nav-tabs-bordered" id="qrTab" role="tablist">

      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="attendance-tab" data-bs-toggle="tab" data-bs-target="#attendance" type="button" role="tab">
          Attendance QR
        </button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="fees-tab" data-bs-toggle="tab" data-bs-target="#fees" type="button" role="tab">
          Online Fees QR
        </button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="feedback-tab" data-bs-toggle="tab" data-bs-target="#feedback" type="button" role="tab">
          Feedback QR
        </button>
      </li>

      <li class="nav-item" role="presentation">
        <button class="nav-link" id="upi-tab" data-bs-toggle="tab" data-bs-target="#upi" type="button" role="tab">
          My UPI QR
        </button>
      </li>

    </ul>

    <div class="tab-content pt-3" id="qrTabContent">


      <!-- ✅ Attendance QR -->
<div class="tab-pane fade show active" id="attendance" role="tabpanel">

  <?php 
    $attendance_url = $settings['base_url']."attendance.php"; 
    $attendance_qr = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=".urlencode($attendance_url);
  ?>

  <div id="attendancePrint" class="qr-print-area print-area">
      <img src="<?php echo $settings['logo']; ?>" class="company-logo">
      <p class="para-margin text-large">Scan this QR to record attendance.</p>

      <div class="qr-box">
        <img src="<?php echo $attendance_qr; ?>" width="350">
      </div>

      <h3 class="margin-top-large">Attendance QR Code</h3>
<div style="margin-top: 10px; font-size: 12px; color: #555;">
    Powered by <img src="./educaerp.jpg" 
    style="height: 18px; vertical-align: middle; opacity: 0.7;">
</div>

  </div>

  <button class="btn btn-primary print-btn" onclick="printQR('attendancePrint')">
      Download / Print
  </button>

</div>


<!-- ✅ Online Fees QR -->
<div class="tab-pane fade" id="fees" role="tabpanel">

  <?php 
    $fees_url = $settings['base_url']."online-payment.php"; 
    $fees_qr = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=".urlencode($fees_url);
  ?>

  <div id="feesPrint" class="qr-print-area print-area">
      <img src="<?php echo $settings['logo']; ?>" class="company-logo">
      <p class="para-margin text-large">Scan this QR to pay fees online.</p>

      <div class="qr-box">
        <img src="<?php echo $fees_qr; ?>" width="350">
      </div>

      <h3 class="margin-top-medium">Online Payment QR Code</h3>
      <div style="margin-top: 10px; font-size: 12px; color: #555;">
    Powered by <img src="./educaerp.jpg" 
    style="height: 18px; vertical-align: middle; opacity: 0.7;">
</div>
  </div>

  <button class="btn btn-primary print-btn" onclick="printQR('feesPrint')">
      Download / Print
  </button>

</div>


<!-- ✅ Feedback QR -->
<div class="tab-pane fade" id="feedback" role="tabpanel">

  <?php 
    $feedback_url = $settings['base_url']."feedback.php"; 
    $feedback_qr = "https://api.qrserver.com/v1/create-qr-code/?size=500x500&data=".urlencode($feedback_url);
  ?>

  <div id="feedbackPrint" class="qr-print-area print-area">
       <img src="<?php echo $settings['logo']; ?>" class="company-logo">
      <p class="para-margin text-large">Scan to submit your valuable feedback</p>

      <div class="qr-box">
        <img src="<?php echo $feedback_qr; ?>" width="350">
      </div>

      <h3 class="margin-top-medium">Feedback QR Code</h3>
      <div style="margin-top: 10px; font-size: 12px; color: #555;">
    Powered by <img src="./educaerp.jpg" 
    style="height: 18px; vertical-align: middle; opacity: 0.7;">
</div>
  </div>

  <button class="btn btn-primary print-btn" onclick="printQR('feedbackPrint')">
      Download / Print
  </button>

</div>


<!-- ✅ My UPI QR (using your JS method) -->
<div class="tab-pane fade" id="upi" role="tabpanel">

  <?php 
    $upi = $settings['upi_id']; 
    $name = $settings['site_title'];

    // Payment app style UPI link
    $upiUrl = "upi://pay?pa=".$upi."&pn=".urlencode($name)."&cu=INR";
    $upi_qr = "https://api.qrserver.com/v1/create-qr-code/?size=600x600&data=".urlencode($upiUrl);
  ?>

<div id="upiPrint" class="qr-print-area print-area">

    <div class="standee-container">

        <img src="<?php echo $settings['logo']; ?>" class="company-logo" style="width:120px; margin-top:10px;">

        <div class="standee-title">SCAN & PAY</div>

        <div class="standee-upi-box" style="margin-top:10px;">
            <img src="<?php echo $upi_qr; ?>" style="width:200px;">
        </div>

        <div class="standee-pay-text" style="margin-top:10px;">
            <strong><?php echo $name; ?></strong><br>
            UPI ID: <?php echo $upi; ?>
        </div>
        <div style="margin-top: 10px; font-size: 12px; color: #555;">
    Powered by <img src="./educaerp.jpg" 
    style="height: 18px; vertical-align: middle; opacity: 0.7;">
</div>

    </div>

</div>


  <button class="btn btn-primary print-btn" onclick="printQR('upiPrint')">
      Download / Print
  </button>

</div>



    </div>

  </div>
</div>


        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script>
function printQR(id) {
    let content = document.getElementById(id).innerHTML;

    let win = window.open('', '', 'height=2000,width=1400');

    win.document.write(`
    <html>
    <head>
      <title>Print QR</title>

      <style>
      /* ✅ Force background colors & images to print */
* {
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
    color-adjust: exact !important;
}

        @page { size: A4; margin: 0; }

        body {
            margin: 0;
            padding: 0;
            background: #fff;
            text-align: center;
            font-family: 'Poppins', Arial, sans-serif;
        }

        .print-wrapper {
            width: 210mm;
            min-height: 297mm;
            padding: 15mm;
            margin: 0 auto;
            box-sizing: border-box;
            text-align: center;
        }

        /* ✅ Company Logo */
        .company-logo {
            width: 300px;
            margin-bottom: 10px;
        }

        /* ✅ Fix QR BOX & border */
        .qr-box {
            margin-top: 20px !important;
            padding: 15px;
            border: 2px solid #000 !important;
            display: inline-block;
            background: #fff;
        }

        /* ✅ Reduce gap below QR */
        .qr-box img {
            margin-bottom: 8px !important;
        }

        /* ✅ Standee style UPI box */
        .standee-upi-box {
            border: 3px solid #0056ff !important;
            padding: 20px !important;
            border-radius: 12px !important;
            background: #f8faff !important;
            display: inline-block !important;
            margin-top: 10px !important;
        }

        .standee-title {
            font-size: 26px !important;
            font-weight: bold !important;
            color: #0047d4 !important;
            margin-top: 10px !important;
        }

        .standee-pay-text {
            font-size: 18px !important;
            color: #222 !important;
            margin-top: 10px !important;
        }

        /* ✅ Margin Classes */
        .margin-top-large { margin-top: 20px !important; }
        .margin-top-medium { margin-top: 10px !important; }
        .margin-bottom-large { margin-bottom: 20px !important; }
        .margin-bottom-medium { margin-bottom: 10px !important; }

        /* ✅ Text Sizes */
        .text-large { font-size: 20px !important; }
        .text-medium { font-size: 18px !important; }
        .text-heading { font-size: 26px !important; font-weight: bold; }

        /* ✅ Paragraph fix */
        .para-margin { 
            margin-top: 12px !important; 
            margin-bottom: 12px !important; 
        }

        /* ✅ FORCE CENTER EVERYTHING */
        .print-wrapper * {
            margin-left: auto !important;
            margin-right: auto !important;
            text-align: center !important;
        }
        /* ✅ Exact 4x6 inch standee size */
.standee-container {
    width: 101.6mm !important;
    height: 152.4mm !important;
    background: #e9f1ff !important; 
    border-radius: 12px !important;
    padding: 10px !important;
    box-sizing: border-box !important;
    text-align: center !important;
    margin-left: auto !important;
    margin-right: auto !important;
}

/* ✅ Fix inner elements for standee */
.standee-container img {
    display: block !important;
    margin-left: auto !important;
    margin-right: auto !important;
}

.standee-title {
    font-size: 24px !important;
    font-weight: bold !important;
    margin-top: 8px !important;
    color: #0047d4 !important;
}

.standee-upi-box {
    border: 2px solid #0056ff !important;
    padding: 10px !important;
    border-radius: 10px !important;
    background: #fff !important;
    margin-top: 8px !important;
}

.standee-pay-text {
    font-size: 16px !important;
    margin-top: 10px !important;
    color: #000 !important;
}

      </style>

    </head>

    <body>
      <div class="print-wrapper">
        ${content}
      </div>
    </body>

    </html>
    `);

    win.document.close();
    win.focus();

    setTimeout(() => { 
        win.print();
        win.close(); 
    }, 400);
}
</script>


</body>

</html>