<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

$response = ['success' => false, 'message' => 'Unknown error'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['success' => false, 'message' => 'Invalid request method']);
  exit;
}

// CSRF validation
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
  echo json_encode(['success' => false, 'message' => 'CSRF validation failed']);
  exit;
}

function sanitize($str) {
  return htmlspecialchars(trim($str), ENT_QUOTES, 'UTF-8');
}

$action = sanitize($_POST['action'] ?? '');
$id = intval($_POST['id'] ?? 0);
$code = sanitize($_POST['reference_code'] ?? '');
$title = sanitize($_POST['reference_title'] ?? '');
$status = sanitize($_POST['status'] ?? 'Active');

if ($action != 'delete' && (empty($code) || empty($title))) {
  echo json_encode(['success' => false, 'message' => 'Please fill all required fields.']);
  exit;
}

// Duplicate check for code
$stmt = $conn->prepare("SELECT id FROM enquiries_references WHERE reference_code = ?" . ($action === 'Edit' ? " AND id != ?" : ""));
if ($action === 'Edit') $stmt->bind_param("si", $code, $id);
else $stmt->bind_param("s", $code);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
  echo json_encode(['success' => false, 'message' => 'Reference code already exists.']);
  $stmt->close();
  exit;
}
$stmt->close();

try {
  if ($action === 'Add') {
    $stmt = $conn->prepare("INSERT INTO enquiries_references (reference_code, reference_title, status) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $code, $title, $status);
    if ($stmt->execute()) {
      $response = ['success' => true, 'message' => 'Reference added successfully', 'redirect' => 'references.php'];
    } else {
      $response['message'] = 'Failed to add reference';
    }
    $stmt->close();
  }

  elseif ($action === 'Edit' && $id > 0) {
    $stmt = $conn->prepare("UPDATE enquiries_references SET reference_code=?, reference_title=?, status=? WHERE id=?");
    $stmt->bind_param("sssi", $code, $title, $status, $id);
    if ($stmt->execute()) {
      $response = ['success' => true, 'message' => 'Reference updated successfully', 'redirect' => 'references.php'];
    } else {
      $response['message'] = 'Failed to update reference';
    }
    $stmt->close();
  }

  elseif ($action === 'delete' && $id > 0) {
    $stmt = $conn->prepare("DELETE FROM enquiries_references WHERE id=?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
      $response = ['success' => true, 'message' => 'Reference deleted successfully'];
    } else {
      $response['message'] = 'Failed to delete reference';
    }
    $stmt->close();
  }

  else {
    $response['message'] = 'Invalid action or missing ID';
  }

} catch (Exception $e) {
  $response['message'] = 'Error: ' . $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
