<?php  
include("auth.php");
include("../config.php");

$reference = [];
if (isset($_GET['id'])) {
  $id = base64_decode($_GET['id']);
  $stmt = $conn->prepare("SELECT * FROM enquiries_references WHERE id = ?");
  $stmt->bind_param("i", $id);
  $stmt->execute();
  $result = $stmt->get_result();
  if ($result->num_rows > 0) $reference = $result->fetch_assoc();
  $stmt->close();
}

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?php echo isset($_GET['id']) ? "Edit Reference" : "Add Reference"; ?> - <?php echo $settings['site_name']; ?></title>

  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

  <div class="pagetitle">
    <h1><?php echo isset($_GET['id']) ? "Edit" : "Add"; ?> Reference</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
        <li class="breadcrumb-item active">Reference</li>
      </ol>
    </nav>
  </div>

  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <a href="references.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Back to List</a>
        <div class="card mt-3">
          <div class="card-body">
            <h5 class="card-title">Reference Details</h5>

            <form id="referenceForm" class="row g-3">
              <div class="col-md-6">
                <label for="reference_code" class="form-label">Reference Code <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="reference_code" name="reference_code"
                  value="<?php echo htmlspecialchars($reference['reference_code'] ?? ''); ?>" required>
              </div>

              <div class="col-md-6">
                <label for="reference_title" class="form-label">Reference Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="reference_title" name="reference_title"
                  value="<?php echo htmlspecialchars($reference['reference_title'] ?? ''); ?>" required>
              </div>

              <div class="col-md-6">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                  <option value="Active" <?php if(($reference['status'] ?? '') == 'Active') echo 'selected'; ?>>Active</option>
                  <option value="Inactive" <?php if(($reference['status'] ?? '') == 'Inactive') echo 'selected'; ?>>Inactive</option>
                </select>
              </div>

              <div id="msg"></div>

              <div class="col-md-12">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <?php if (isset($_GET['id'])) { ?>
                  <input type="hidden" name="id" value="<?php echo $id; ?>">
                  <input type="hidden" name="action" value="Edit">
                  <button class="btn btn-success" type="submit">Update</button>
                <?php } else { ?>
                  <input type="hidden" name="action" value="Add">
                  <button class="btn btn-success" type="submit">Submit</button>
                  <button class="btn btn-secondary" type="reset">Reset</button>
                <?php } ?>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </section>

</main>

<?php include("templates/footer.php"); ?>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/main.js"></script>

<script>
document.getElementById("referenceForm").addEventListener("submit", function(e) {
  e.preventDefault();
  const formData = new FormData(this);
  fetch("reference-action.php", { method: "POST", body: formData })
    .then(res => res.json())
    .then(data => {
      const msgDiv = document.getElementById("msg");
      msgDiv.innerHTML = `<div class='alert ${data.success ? "alert-success" : "alert-danger"}'>${data.message}</div>`;
      if (data.success && data.redirect) {
        setTimeout(() => location.href = data.redirect, 2000);
      }
    });
});
</script>
</body>
</html>
