<?php  
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>References - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  
  <style>
#copyToast {
  transform: translateY(20px);
  opacity: 0;
  transition: all 0.3s ease-in-out;
}
#copyToast.show {
  transform: translateY(0);
  opacity: 1;
}
</style>

</head>

<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

  <div class="pagetitle">
    <h1>References</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
        <li class="breadcrumb-item active">References</li>
      </ol>
    </nav>
  </div>

  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <a href="reference.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>

        <div class="card mt-2">
          <div class="card-body">
            <h5 class="card-title">Reference List</h5>

            <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>Reference Code</th>
                    <th>Reference Title</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
$sql = "SELECT * FROM enquiries_references ORDER BY id ASC";
$result = mysqli_query($conn, $sql);
$sl = 1;

// ✅ Fetch base_url once
$base_url = $settings['base_url'];

if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
    $full_url = rtrim($base_url, '/') . "/index.php?r=" . urlencode($row['reference_code']);
    echo "<tr>";
    echo "<td>".$sl."</td>";
    echo "<td style='white-space: nowrap;'>
            <a href='reference.php?id=" . base64_encode($row['id']) . "' class='btn btn-sm btn-warning'><i class='bi bi-pencil'></i></a>
            <button class='btn btn-sm btn-info' title='".$full_url."' onclick=\"copyURL('".$full_url."')\">
              <i class='bi bi-clipboard'></i> Copy URL
            </button>
            <button class='btn btn-sm btn-danger' onclick='deleteReference(".$row['id'].")'>
              <i class='bi bi-trash'></i>
            </button>
          </td>";
    echo "<td>".htmlspecialchars($row['reference_code'])."</td>";
    echo "<td>".htmlspecialchars($row['reference_title'])."</td>";
    echo "<td>".htmlspecialchars($row['status'])."</td>";
    echo "</tr>";
    $sl++;
  }
} else {
  echo "<tr><td colspan='5' class='text-center'>No references found.</td></tr>";
}
?>

                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

</main>



<?php include("templates/footer.php"); ?>

<!-- ✅ Copy Toast Notification -->
<div class="position-fixed top-0 end-0 p-3" style="z-index: 9999">
  <div id="copyToast" class="toast align-items-center text-bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body fw-semibold ">
        URL copied to clipboard!
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>


<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/js/main.js"></script>

<script>
function deleteReference(id) {
  if (confirm("Are you sure you want to delete this reference?")) {
    fetch('reference-action.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: 'action=delete&id=' + id + '&csrf_token=<?php echo $_SESSION['csrf_token']; ?>'
    })
    .then(res => res.json())
    .then(data => {
      alert(data.message);
      if (data.success) location.reload();
    });
  }
}

function copyURL(url) {
  navigator.clipboard.writeText(url).then(() => {
    // Show Bootstrap toast
    const toastEl = document.getElementById('copyToast');
    const toast = new bootstrap.Toast(toastEl, { delay: 1500 }); // Auto-hide in 1.5s
    toast.show();
  }).catch(err => {
    console.error("Failed to copy:", err);
  });
}
</script>

</body>
</html>
