<?php  
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Subscribers - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <!--<link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">-->

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<style>
.dataTables_length {
    margin-right: 15px !important;
}

.dt-buttons .btn {
    margin-right: 5px;
}
</style>
<style>
@media (max-width: 768px) {
    /* Container becomes flex */
    .dataTables_wrapper .dt-buttons,
    .dataTables_wrapper .dataTables_length {
        float: none;
        display: inline-flex;
        align-items: center;
        margin-bottom: 8px;
    }

    /* Put length + buttons on same row */
    .dataTables_wrapper .dataTables_length {
        margin-right: 10px;
    }

    /* Allow wrapping if needed without stacking vertically */
    .dataTables_wrapper .dt-buttons {
        flex-wrap: nowrap;
    }

    /* Search goes below */
    .dataTables_wrapper .dataTables_filter {
        float: none;
        margin-top: 10px;
        width: 100%;
        text-align: left;
    }
}
</style>
</head>

<body>

  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Registrations</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Registrations</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Registration List</h5>

              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

              <!-- Table -->
              <div class="table-responsive">
                <table class="table datatable">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Name</th>
                      <th>Email</th>
                      <th>Mobile</th>
                      <th>Status</th>
                      <th>Created At</th>
                      <th>Updated At</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $sql = "SELECT * FROM subscriber WHERE deleted_at IS NULL ORDER BY id DESC";
                    $result = mysqli_query($conn, $sql);
                    $sl = 1;

                    if ($result && mysqli_num_rows($result) > 0) {
                      while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td style='white-space: nowrap;'>" . $sl . "</td>";
                        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['name']) . "</td>";
                        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['email']) . "</td>";
                        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['mobile_no']) . "</td>";

                        // Status color badge
                        $badgeClass = ($row['status'] === 'subscribed') ? 'bg-success' : 'bg-secondary';
                        echo "<td><span class='badge $badgeClass'>" . htmlspecialchars($row['status']) . "</span></td>";

                        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['created_at']) . "</td>";
                        echo "<td style='white-space: nowrap;'>" . htmlspecialchars($row['updated_at'] ?? '-') . "</td>";
                        echo "</tr>";
                        $sl++;
                      }
                    } else {
                      echo "<tr><td colspan='7' class='text-center'>No subscribers found.</td></tr>";
                    }
                    ?>
                  </tbody>
                </table>
              </div>
              <!-- End Table -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <!--<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>-->
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<!-- jQuery (must load first) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- jQuery DataTables Core -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">

<!-- PDF Export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>


<script>
$(document).ready(function() {
    $('.datatable').DataTable({
        dom: 'lBfrtip', // Added 'l' to restore rows-per-page
        buttons: [
         {
    extend: 'csvHtml5',
    text: '<i class="bi bi-file-earmark-spreadsheet"></i>',
    className: 'btn btn-primary btn-sm'
},
{
    extend: 'pdfHtml5',
    orientation: 'landscape',
    pageSize: 'A4',
    text: '<i class="bi bi-file-earmark-pdf"></i>',
    className: 'btn btn-danger btn-sm'
},
{
    extend: 'print',
    text: '<i class="bi bi-printer"></i>',
    className: 'btn btn-secondary btn-sm'
}

        ],
        initComplete: function () {
    // Remove label text ("Search:")
    $('.dataTables_filter label').contents().filter(function() {
        return this.nodeType === 3;
    }).remove();

    // Add placeholder for search
    $('.dataTables_filter input').attr('placeholder', 'Search here...');

    // Remove text from "Show X entries" label
    $('.dataTables_length label').contents().filter(function() {
        return this.nodeType === 3;
    }).remove();
}

    });
});

</script>
</body>
</html>
