<?php
include("../config.php");
session_start();

// --- Security ---
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    die("CSRF token mismatch");
}

// --- Input Data ---
$bid = intval($_POST['bid']);
$date = trim($_POST['date']);
$marked_by = intval($_SESSION['user_id'] ?? 0);

// --- Validation ---
if (!$bid || !$date) {
    die("Missing required fields");
}

if (empty($_POST['mobile']) || !is_array($_POST['mobile'])) {
    die("no_students");
}

// --- Prepare reusable statements ---
$checkStmt = $conn->prepare("SELECT id FROM attendance WHERE bid=? AND student_mobile=? AND date=? LIMIT 1");
$insertStmt = $conn->prepare("INSERT INTO attendance (bid, student_mobile, date, status, marked_by, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
$updateStmt = $conn->prepare("UPDATE attendance SET status=?, marked_by=?, updated_at=NOW() WHERE bid=? AND student_mobile=? AND date=?");

// --- Loop through all students ---
foreach ($_POST['mobile'] as $mobile) {
    $mobile = trim($mobile);
    $status = $_POST['status'][$mobile] ?? 'Absent';

    // 1️⃣ Check if record exists
    $checkStmt->bind_param("iss", $bid, $mobile, $date);
    $checkStmt->execute();
    $checkStmt->store_result();

    if ($checkStmt->num_rows > 0) {
        // 2️⃣ Update existing record
        $updateStmt->bind_param("siiss", $status, $marked_by, $bid, $mobile, $date);
        $updateStmt->execute();
    } else {
        // 3️⃣ Insert new record
        $insertStmt->bind_param("isssi", $bid, $mobile, $date, $status, $marked_by);
        $insertStmt->execute();
    }
}

$checkStmt->close();
$insertStmt->close();
$updateStmt->close();

echo "success";
?>

