var quill = new Quill('#quillEditor', {
  theme: 'snow',
  modules: {
    toolbar: {
      container: [
        [{ header: [1, 2, 3, false] }],
        ['bold', 'italic', 'underline'],
        [{ 'color': [] }, { 'background': [] }],
        ['link', 'image', 'code-block'],
        [{ list: 'ordered' }, { list: 'bullet' }]
      ],
      handlers: {
        'image': imageHandler
      }
    },
    imageResize: true
  },
  placeholder: 'Enter content here...'
});

// Custom image handler
function imageHandler() {
  var input = document.createElement('input');
  input.setAttribute('type', 'file');
  input.setAttribute('accept', 'image/*');
  input.click();

  input.onchange = function() {
    var file = input.files[0];
    if (/^image\//.test(file.type)) {
      var formData = new FormData();
      formData.append('image', file);

      // Upload to server
      fetch('upload-image.php', {
        method: 'POST',
        body: formData
      })
      .then(response => response.json())
      .then(result => {
        if (result.success) {
          // Insert image into Quill
          let range = quill.getSelection();
          quill.insertEmbed(range.index, 'image', result.url);
        } else {
          alert(result.message);
        }
      })
      .catch(err => console.error('Error uploading image:', err));
    } else {
      alert('Please select an image file.');
    }
  };
}


// Set initial content if editing
quill.root.innerHTML = typeof contentData !== 'undefined' ? contentData : '';

// Form submission via AJAX
var form = document.getElementById('contentform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault(); // prevent default submission
  
    const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

// Copy Quill content to hidden input
var quillContent = quill.root.innerHTML.trim();
document.querySelector('#content').value = quillContent;

// Check if content is empty or contains only whitespace AND has no images
var tempDiv = document.createElement("div");
tempDiv.innerHTML = quillContent;

// Get plain text
var plainText = tempDiv.textContent || tempDiv.innerText || "";

// Check for <img> tags
var hasImage = tempDiv.querySelectorAll('img').length > 0;

// If no text AND no images, show error
if (plainText.trim() === "" && !hasImage) {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Enter Content to continue.</div>';
    $("#quillEditor").focus();
    return; // stop form submission
}


  // Prepare form data
  var formData = new FormData(form);

  // Send AJAX request
  fetch('content-action.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '';

    if (data.success) {
      msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
      
      // Optionally redirect after a short delay
      if (data.redirect) {
        setTimeout(function() {
          window.location.href = data.redirect;
        }, 1500);
      }

    } else {
      msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
    }
  })
  .catch(error => {
    console.error('Error:', error);
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
  })
  .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});

// Delete Content
function deleteContent(contentId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this content?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: contentId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'content-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the content.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}






