// ===============================
// Expense Form Submission (Add / Edit)
// ===============================
var form = document.getElementById('expenseform'); // Updated form ID

form.addEventListener('submit', function(e) {
  e.preventDefault();

  const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

  const formData = new FormData(form);

  fetch('expense-action.php', { method: 'POST', body: formData })
    .then(response => response.json())
    .then(data => {
      const msgDiv = document.getElementById('msg');
      msgDiv.innerHTML = '';

      if (data.success) {
        msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
        if (data.redirect) {
          setTimeout(() => window.location.href = data.redirect, 1500);
        }
      } else {
        msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
      }
    })
    .catch(error => {
      console.error('Error:', error);
      document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent =
        form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});


// ===============================
// Delete Expense
// ===============================
function deleteExpense(expenseId) {
  if (!confirm('Are you sure you want to delete this expense?')) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  const data = {
    action: 'delete',
    id: expenseId,
    csrf_token: csrfToken
  };

  const xhr = new XMLHttpRequest();
  xhr.open('POST', 'expense-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  xhr.onload = function() {
    if (xhr.status === 200) {
      const response = JSON.parse(xhr.responseText);

      if (response.success === true) {
        location.reload();
      } else {
        alert(response.message);
      }
    } else {
      alert('An error occurred while deleting the expense.');
    }
  };

  xhr.send(
    'action=' + data.action +
    '&id=' + data.id +
    '&csrf_token=' + encodeURIComponent(data.csrf_token)
  );
}


// ===============================
// Toggle Expense Status (Activate / Deactivate)
// ===============================
function toggleExpenseStatus(expenseId, actionType) {
  if (!confirm(`Are you sure you want to ${actionType.toLowerCase()} this expense?`)) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  fetch('expense-action.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `action=${encodeURIComponent(actionType)}&id=${encodeURIComponent(expenseId)}&csrf_token=${encodeURIComponent(csrfToken)}`
  })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        location.reload();
      } else {
        alert('Error: ' + data.message);
      }
    })
    .catch(err => {
      console.error(err);
      alert('Something went wrong while updating expense status.');
    });
}

$(document).ready(function () {
  $("#expenseform").on("submit", function (e) {
    e.preventDefault();

    $("#uploadLoader").show(); // show loader

    let formData = new FormData(this);

    $.ajax({
      url: "expense-action.php",
      type: "POST",
      data: formData,
      processData: false,
      contentType: false,
      success: function (response) {
        $("#uploadLoader").hide();

        if (response.success) {
          $("#msg").html(`<div class="alert alert-success">${response.message}</div>`);
          setTimeout(() => window.location.href = "expenses.php", 1200);
        } else {
          $("#msg").html(`<div class="alert alert-danger">${response.message}</div>`);
        }
      },
      error: function () {
        $("#uploadLoader").hide();
        $("#msg").html('<div class="alert alert-danger">Something went wrong.</div>');
      }
    });
  });
});

