document.addEventListener('DOMContentLoaded', function() {
    const mediaTypeSelect = document.getElementById('type');  // Dropdown for Media Type
    const mediaUrlInput = document.getElementById('media_url');
    const mediaUrlInputGroup = document.getElementById('media_url_input_group');

    // Initialize the form based on the PHP variables injected
    if (mediaType) {
        handleMediaTypeChange(mediaType, mediaUrl);
    }

    // Function to handle change in media type
    mediaTypeSelect.addEventListener('change', function() {
        const mediaType = mediaTypeSelect.value;
        handleMediaTypeChange(mediaType, '');
    });

    // Function to handle input layout based on media type
    function handleMediaTypeChange(mediaType, mediaUrl) {
        // Reset the input field when media type changes
        mediaUrlInput.value = '';
        mediaUrlInput.removeAttribute('readonly'); // Remove readonly if previously set

        // Handle different media types
        if (mediaType === 'Image') {
            mediaUrlInput.type = 'file';
            mediaUrlInput.accept = 'image/*'; // Only image files
            mediaUrlInputGroup.innerHTML = `
                <input type="file" class="form-control" id="media_url" name="media_url" accept="image/*" >
                <div class="input-group-append">
                    ${mediaUrl ? `<span class='input-group-text'><a href='../${mediaUrl}' target='_blank' class='btn btn-sm btn-outline-primary'>View File</a></span>` : ''}
                </div>`;
        } else if (mediaType === 'Video') {
            mediaUrlInput.type = 'text';
            // mediaUrlInput.accept = 'video/mp4, video/x-m4v, video/*'; // Only video files
            mediaUrlInputGroup.innerHTML = `<input type="text" class="form-control" id="media_url" name="media_url" value="${mediaUrl}" placeholder="Enter or Paste Video Link" required>`;
        } else if (mediaType === 'PDF') {
            mediaUrlInput.type = 'file';
            mediaUrlInput.accept = '.pdf,.doc,.docx'; // Only PDF and Word files
            mediaUrlInputGroup.innerHTML = `
                <input type="file" class="form-control" id="media_url" name="media_url" accept=".pdf,.doc,.docx" >
                <div class="input-group-append">
                    ${mediaUrl ? `<span class='input-group-text'><a href='../${mediaUrl}' target='_blank' class='btn btn-sm btn-outline-primary'>View File</a></span>` : ''}
                </div>`;
        } else if (mediaType === 'Links') {
            mediaUrlInput.type = 'text'; // For Links, show a text input
            mediaUrlInput.placeholder = 'Enter or Paste Link';
            mediaUrlInputGroup.innerHTML = `
                <input type="text" class="form-control" id="media_url" name="media_url" value="${mediaUrl}" placeholder="Enter or Paste Link" required>`;
        }
    }
});



// Form submission via AJAX
var form = document.getElementById('mediaform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault(); // prevent default submission
  
    const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

  // Prepare form data
  var formData = new FormData(form);

  // Send AJAX request
  fetch('media-action.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '';

    if (data.success) {
      msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
      
      // Optionally redirect after a short delay
      if (data.redirect) {
        setTimeout(function() {
          window.location.href = data.redirect;
        }, 1500);
      }

    } else {
      msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
    }
  })
  .catch(error => {
    console.error('Error:', error);
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
  })
  .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});

// Delete Media
function deleteMedia(mediaId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this Media?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: mediaId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'media-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the media.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}




