


// ️ DELETE NEWSLETTER (currently unused)

function deleteNotice(noticeId) {
  if (!confirm('Are you sure you want to delete this notice?')) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  const data = {
    action: 'delete',
    id: noticeId,
    csrf_token: csrfToken
  };

  const xhr = new XMLHttpRequest();
  xhr.open('POST', 'notice-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  xhr.onload = function () {
    if (xhr.status === 200) {
      const response = JSON.parse(xhr.responseText);
      if (response.success === true) {
        location.reload();
      } else {
        alert(response.message);
      }
    } else {
      alert('An error occurred while deleting the notice.');
    }
  };

  xhr.send(
    'action=' + data.action +
    '&id=' + data.id +
    '&csrf_token=' + encodeURIComponent(data.csrf_token)
  );
}


// -------------------------------------------
// 🔄 TOGGLE NEWSLETTER STATUS (Subscribe / Unsubscribe)
// -------------------------------------------
function toggleNewsletterStatus(newsletterId, actionType) {
  if (!confirm(`Are you sure you want to ${actionType.toLowerCase()} this subscriber?`)) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  fetch('newsletter-action.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body:
      'action=' + encodeURIComponent(actionType) +
      '&id=' + encodeURIComponent(newsletterId) +
      '&csrf_token=' + encodeURIComponent(csrfToken)
  })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        // alert(data.message);
        location.reload();
      } else {
        alert('Error: ' + data.message);
      }
    })
    .catch(err => {
      console.error(err);
      alert('Something went wrong while updating status.');
    });
}


