document.addEventListener('DOMContentLoaded', function () {
  const form = document.getElementById('profileform');
  if (!form) return;

  form.addEventListener('submit', function(e) {

    // ✅ Otherwise block submit and use AJAX
    e.preventDefault();
    
      const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

    let formData = new FormData(this);

    fetch('profile-action.php', {
      method: 'POST',
      body: formData,
    })
    .then(response => response.json())
    .then(data => {
      let messageDiv = document.getElementById('message');
      if (data.status === 'success') {
        messageDiv.innerHTML = `<div class="alert alert-success">${data.message}</div>`;
        setTimeout(function() {
          location.reload();
        }, 3000);
      } else {
        messageDiv.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
      }
    })
    .catch(error => {
      console.error('Error:', error);
      document.getElementById('message').innerHTML =
        `<div class="alert alert-danger">An error occurred. Please try again.</div>`;
    })
     .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Update Profile';
    });
  });
});
