
// Form submission via AJAX
var form = document.getElementById('studentcornerform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault();

  const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

  const formData = new FormData(form);

  fetch('student-corner-action.php', { method: 'POST', body: formData })
    .then(response => response.json())
    .then(data => {
      const msgDiv = document.getElementById('msg');
      msgDiv.innerHTML = '';

      if (data.success) {
        msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
        if (data.redirect) {
          setTimeout(() => window.location.href = data.redirect, 1500);
        }
      } else {
        msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
      }
    })
    .catch(error => {
      console.error('Error:', error);
      document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});


// Delete Content
function deleteStudentcorner(studentcornerId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this File/Link?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: studentcornerId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'student-corner-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the File/Link.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}

// Toggle Course Status (Activate / Deactivate)
function togglestudentcornerStatus(studentcornerId, actionType) {
  if (!confirm(`Are you sure you want to ${actionType.toLowerCase()} this File/Link?`)) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  fetch('student-corner-action.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `action=${encodeURIComponent(actionType)}&id=${encodeURIComponent(studentcornerId)}&csrf_token=${encodeURIComponent(csrfToken)}`
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
    //   alert(data.message);
      location.reload();
    } else {
      alert('Error: ' + data.message);
    }
  })
  .catch(err => {
    console.error(err);
    alert('Something went wrong while updating status.');
  });
}





