
  const passwordInput = document.getElementById('password');
  const toggle = document.getElementById('togglePassword');
  const icon = toggle.querySelector('i');

  toggle.addEventListener('click', function() {
    if(passwordInput.type === 'password'){
      passwordInput.type = 'text';
      icon.classList.remove('bi-eye');
      icon.classList.add('bi-eye-slash');
    } else {
      passwordInput.type = 'password';
      icon.classList.remove('bi-eye-slash');
      icon.classList.add('bi-eye');
    }
  });

// Form submission via AJAX
var form = document.getElementById('userform'); // use the ID
form.addEventListener('submit', function(e) {
  e.preventDefault(); // prevent default submission

const submitBtn = form.querySelector('button[type="submit"]');
  submitBtn.disabled = true;
  submitBtn.textContent = 'Please wait...';

  // Prepare form data
  var formData = new FormData(form);

  // Send AJAX request
fetch('user-action.php', { method: 'POST', body: formData })
  .then(response => response.json())
  .then(data => {
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '';

    if (data.success) {
      msgDiv.innerHTML = '<div class="alert alert-success">' + data.message + '</div>';
      
      // Optionally redirect after a short delay
      if (data.redirect) {
        setTimeout(function() {
          window.location.href = data.redirect;
        }, 1500);
      }

    } else {
      msgDiv.innerHTML = '<div class="alert alert-danger">' + data.message + '</div>';
    }
  })
  .catch(error => {
    console.error('Error:', error);
    var msgDiv = document.getElementById('msg');
    msgDiv.innerHTML = '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
  })
  .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = form.querySelector('input[name="action"]').value === 'Edit' ? 'Update' : 'Submit';
    });
});

// Delete Content
function deleteUser(userId) {
  // Confirm the action
  if (!confirm('Are you sure you want to delete this user?')) {
    return;
  }

  // Get the CSRF token from the page (it should be embedded as a hidden field or from a meta tag)
  var csrfToken = document.querySelector('input[name="csrf_token"]').value;

  // Prepare the data to be sent
  var data = {
    action: 'delete',
    id: userId,
    csrf_token: csrfToken  // Include CSRF token in the data
  };

  // Perform the AJAX request
  var xhr = new XMLHttpRequest();
  xhr.open('POST', 'user-action.php', true);
  xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

  // Handle the response
  xhr.onload = function() {
    if (xhr.status === 200) {
      var response = JSON.parse(xhr.responseText);

      // Check if the response was successful
      if (response.success === true) {
        location.reload();  // Reload the page on success
      } else {
        alert(response.message);  // Show error message
      }
    } else {
      alert('An error occurred while deleting the user.');
    }
  };

  // Send the data
  xhr.send('action=' + data.action + '&id=' + data.id + '&csrf_token=' + encodeURIComponent(data.csrf_token));
}

// Toggle user Status (Activate / Deactivate)
function toggleUserStatus(courseId, actionType) {
  if (!confirm(`Are you sure you want to ${actionType.toLowerCase()} this user?`)) {
    return;
  }

  const csrfToken = document.querySelector('input[name="csrf_token"]').value;

  fetch('user-action.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `action=${encodeURIComponent(actionType)}&id=${encodeURIComponent(courseId)}&csrf_token=${encodeURIComponent(csrfToken)}`
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
    //   alert(data.message);
      location.reload();
    } else {
      alert('Error: ' + data.message);
    }
  })
  .catch(err => {
    console.error(err);
    alert('Something went wrong while updating status.');
  });
}




