<?php
include("../config.php");
header('Content-Type: application/json');

require './PHPMailer/PHPMailer.php';
require './PHPMailer/SMTP.php';
require './PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// JSON helper
function j($arr){ echo json_encode($arr); exit; }

/* Fetch full details for reminder */
function getEnrolmentDetails($enrolment_id) {
    global $conn;

    $eid = mysqli_real_escape_string($conn, $enrolment_id);

    $sql = "
        SELECT 
            s.name AS student_name,
            s.email,
            s.mobile,
            e.enrolment_id,
            c.name AS course_name,
            (c.fees - c.discount) AS total_fees,
            (
                SELECT SUM(payment_amount)
                FROM fees_receipts 
                WHERE enrolment_id = e.enrolment_id
            ) AS paid_amount,
            (
                SELECT next_payment_date
                FROM fees_receipts 
                WHERE enrolment_id = e.enrolment_id
                ORDER BY id DESC LIMIT 1
            ) AS next_payment_date
        FROM enrolments e
        LEFT JOIN student s ON e.mobile = s.mobile
        LEFT JOIN course c ON e.cid = c.id
        WHERE e.enrolment_id = '$eid'
        LIMIT 1
    ";

    $res = mysqli_query($conn, $sql);
    return mysqli_fetch_assoc($res);
}

/* Build Email Template */
function buildMessage($d){
    $balance = $d['total_fees'] - $d['paid_amount'];

    return "
        <h3>Fee Payment Reminder</h3>

        <p>Dear <strong>{$d['student_name']}</strong>,</p>

        <p>This is a reminder for your pending payment for the course 
        <strong>{$d['course_name']}</strong>.</p>

        <p>
            Total Fees: <strong>₹{$d['total_fees']}</strong><br>
            Paid: <strong>₹{$d['paid_amount']}</strong><br>
            Balance: <strong>₹{$balance}</strong><br>
        </p>

        <p>Please clear your dues at the earliest.</p>

        <br>
        <p>Regards,<br><strong>Smart Institute</strong></p>
    ";
}

/* Email Sender (using settings table) */
function sendMail($to, $subject, $message){
    global $conn;

    $set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM settings LIMIT 1"));

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host     = $set['smtp_host'];
        $mail->SMTPAuth = true;

        /*  
            AUTO SWITCH:
            If Brevo is selected AND username/password are empty,
            fallback to environment variables.
        */
        if (
            strtolower(trim($set['smtp_host'])) === 'smtp-relay.brevo.com'
            && (empty(trim($set['username'])) || empty(trim($set['password'])))
        ) {
            // Use environment vars
            $mail->Username = getenv('SMTP_USER');
            $mail->Password = getenv('SMTP_PASS');
        } else {
            // Use settings table
            $mail->Username = $set['username'];
            $mail->Password = $set['password'];
        }

        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $set['port_number'];

        $mail->setFrom($set['sender_email'], $set['display_name_email']);
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;

        if($mail->send()){
            return true;
        } else {
            return $mail->ErrorInfo;
        }

    } 
    catch (Exception $e) {
          return "Email sending failed: " . $e->getMessage() . 
           ". Please check your Email Settings and verify that the SMTP Host, Username, Password, Port, and Sender Email are correctly entered.";
     }

}



/* ------------------------
   INDIVIDUAL REMINDER
-------------------------*/
if(isset($_POST['mobile'], $_POST['enrolment_id'])){

    $details = getEnrolmentDetails($_POST['enrolment_id']);

    if(!$details || empty($details['email'])){
        j(['status'=>'error','message'=>'Email not found']);
    }

    $msg = buildMessage($details);

    $result = sendMail($details['email'], "Fee Payment Reminder", $msg);

if($result === true){
    j(['status'=>'success']);
} else {
    j(['status'=>'error','message'=>$result]);  // show actual SMTP error
}

}

/* ------------------------
   BULK REMINDERS
-------------------------*/
if(isset($_POST['items'])){
    $items = $_POST['items'];

    if(!is_array($items)) j(['status'=>'error','message'=>'Invalid input']);

    $success=0; $fail=0;

    foreach($items as $i){
        $details = getEnrolmentDetails($i['enrolment_id']);

        if(!$details || empty($details['email'])){
            $fail++; continue;
        }

        $msg = buildMessage($details);

        if(sendMail($details['email'], "Fee Payment Reminder", $msg)){
            $success++;
        } else {
            $fail++;
        }
    }

    j([
        'status'=>'success',
        'sent'=>$success,
        'failed'=>$fail
    ]);
}

j(['status'=>'error','message'=>'Invalid request']);

