<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("../config.php");

header('Content-Type: application/json');

// CSRF check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo json_encode(["status" => false, "message" => "CSRF validation failed"]);
    exit;
}

require './PHPMailer/PHPMailer.php';
require './PHPMailer/SMTP.php';
require './PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

/* -----------------------------
   EMAIL SENDER
------------------------------ */
function sendNewsletterMail($to, $subject, $message) {
    global $conn;

    $set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM settings LIMIT 1"));

    $mail = new PHPMailer(true);

    try {

        $mail->isSMTP();
        $mail->Host       = $set['smtp_host'];
        $mail->SMTPAuth   = true;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $set['port_number'];

        $mail->Username   = $set['username'];
        $mail->Password   = $set['password'];

        $mail->setFrom($set['sender_email'], $set['display_name_email']);
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;

        return $mail->send() ? true : false;

    } catch (Exception $e) {
        return $e->getMessage();
    }
}

/* -----------------------------
   REQUIRED FIELDS CHECK
------------------------------ */
if (
    empty($_POST['subject']) ||
    empty($_POST['message']) ||
    empty($_POST['emails'])
) {
    echo json_encode(["status" => false, "message" => "Missing required fields"]);
    exit;
}

$subject = mysqli_real_escape_string($conn, $_POST['subject']);
$message = $_POST['message'];  // HTML allowed
$emails  = json_decode($_POST['emails'], true);

if (!is_array($emails) || count($emails) === 0) {
    echo json_encode(["status" => false, "message" => "No email recipients found"]);
    exit;
}

/* -----------------------------
   INSERT INTO newsletter_contents TABLE
------------------------------ */
$q = $conn->prepare("
    INSERT INTO newsletter_contents(subject, message, attachment, date, status)
    VALUES(?, ?, '', NOW(), 'Sent')
");
$q->bind_param("ss", $subject, $message);
$q->execute();
$content_id = $q->insert_id;

/* -----------------------------
   SEND BULK EMAILS
------------------------------ */
$sent = 0;
$failed = 0;

foreach ($emails as $email) {

    $status = sendNewsletterMail($email, $subject, $message);

    if ($status === true) {
        $sent++;
    } else {
        $failed++;
    }
}

/* -----------------------------
   RETURN RESPONSE
------------------------------ */
echo json_encode([
    "status" => true,
    "message" => "Bulk newsletter sent",
    "sent" => $sent,
    "failed" => $failed,
    "content_id" => $content_id
]);
exit;
