<?php  
include("auth.php");
include("../config.php");

$studentfile = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM student_corner WHERE id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $studentfile = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Student Corner File not found.";
        exit;
    }

    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Student Corner File/Link <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Student Corner File/Link</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Student Corner File/Link</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="student-corner-library.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i>Student Corner Library</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Student Corner File Details</h5>
              
<form class="row g-3" id="studentcornerform" enctype="multipart/form-data">

  <!-- Type -->
  <div class="col-md-3">
    <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
    <select class="form-select" id="type" name="type" required>
      <option value="">Select Type</option>
      <option value="Downloads" <?php if(isset($studentfile['type']) && $studentfile['type']=="Downloads") echo "selected"; ?>>Downloads</option>
      <option value="Study Materials" <?php if(isset($studentfile['type']) && $studentfile['type']=="Study Materials") echo "selected"; ?>>Study Materials</option>
      <option value="Assignments" <?php if(isset($studentfile['type']) && $studentfile['type']=="Assignments") echo "selected"; ?>>Assignments</option>
      <option value="Notes" <?php if(isset($studentfile['type']) && $studentfile['type']=="Notes") echo "selected"; ?>>Notes</option>
      <option value="Videos" <?php if(isset($studentfile['type']) && $studentfile['type']=="Videos") echo "selected"; ?>>Videos</option>
      <option value="Links" <?php if(isset($studentfile['type']) && $studentfile['type']=="Links") echo "selected"; ?>>Links</option>
      <option value="Quiz" <?php if(isset($studentfile['type']) && $studentfile['type']=="Quiz") echo "selected"; ?>>Quiz</option>
      <option value="Live" <?php if(isset($studentfile['type']) && $studentfile['type']=="Live") echo "selected"; ?>>Live</option>
    </select>
  </div>

  <!-- Title -->
  <div class="col-md-6">
    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="title" name="title"
      value="<?php echo isset($studentfile['title']) ? htmlspecialchars($studentfile['title']) : ''; ?>"
      placeholder="Enter Title" required>
  </div>
  
<div class="col-md-3">
  <label for="restriction" class="form-label">Restriction <span class="text-danger">*</span></label>
  <select class="form-select" id="restriction" name="restriction" required>
    <option value="Free" <?php echo (isset($studentfile['restriction']) && $studentfile['restriction'] == 'Free') ? 'selected' : ''; ?>>Free</option>
    <option value="Restricted" <?php echo (!isset($studentfile['restriction']) || $studentfile['restriction'] == 'Restricted') ? 'selected' : ''; ?>>Restricted</option>
  </select>
</div>


  <!-- Link Input (for Videos / Links) -->
  <div class="col-md-12" id="linkInput" style="display:none;">
    <label for="link" class="form-label">Link <span class="text-danger">*</span></label>
    <input type="url" class="form-control" id="link" name="link"
      value="<?php echo isset($studentfile['link']) && ($studentfile['type']=="Videos" || $studentfile['type']=="Links" || $studentfile['type']=="Quiz" || $studentfile['type']=="Live") ? htmlspecialchars($studentfile['link']) : ''; ?>"
      placeholder="Enter or paste the URL link">
  </div>

  <!-- File Upload (for Downloads, Notes, Assignments, Study Materials) -->
<!-- File Upload (for Downloads, Notes, Assignments, Study Materials) -->
<div class="col-md-12" id="fileInput" style="display:none;">
  <label for="fileUpload" class="form-label">Upload File <span class="text-danger">*</span></label>

  <?php if (isset($studentfile['type']) && 
            $studentfile['type'] != "Videos" && 
            $studentfile['type'] != "Links" && 
            $studentfile['type'] != "Quiz" && 
            $studentfile['type'] != "Live" &&
            !empty($studentfile['link'])) { ?>
  
    <div class="input-group">
      <input type="file" class="form-control" id="fileUpload" name="fileUpload"
             accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.ppt,.pptx">
      <a href="./<?php echo htmlspecialchars($studentfile['link']); ?>" target="_blank" class="btn btn-outline-primary">
        <i class="bi bi-eye"></i> View File
      </a>
    </div>
  
  <?php } else { ?>
  
    <input type="file" class="form-control" id="fileUpload" name="fileUpload"
           accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.ppt,.pptx">
  
  <?php } ?>
</div>


  <div id="msg"></div>

  <!-- Hidden and Submit Buttons -->
  <div class="col-md-12">
    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
    <?php if(isset($_GET['id'])) { ?>
      <input type="hidden" name="id" value="<?php echo $id; ?>">
      <input type="hidden" name="action" value="Edit">
      <button class="btn btn-success" type="submit">Update</button>
      <a href="student-corner-library.php" class="btn btn-secondary">Cancel</a>
    <?php } else { ?>
      <input type="hidden" name="action" value="Add">
      <button class="btn btn-success" type="submit">Submit</button>
      <button class="btn btn-secondary" type="reset">Reset</button>
    <?php } ?>
  </div>
</form>

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script src="./scripts/student-corner.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
  const typeSelect = document.getElementById('type');
  const linkInput = document.getElementById('linkInput');
  const fileInput = document.getElementById('fileInput');
  const linkField = document.getElementById('link');
  const fileField = document.getElementById('fileUpload');

function toggleInputs() {
    const selected = typeSelect.value;

    // ✅ These 4 types use LINK field
    if (["Videos", "Links", "Quiz", "Live"].includes(selected)) {
        linkInput.style.display = "block";
        fileInput.style.display = "none";

        linkField.required = true;
        fileField.required = false;
        fileField.value = "";
    } 

    // ✅ These use FILE upload
    else if (selected) {
        fileInput.style.display = "block";
        linkInput.style.display = "none";

        fileField.required = <?php echo isset($_GET['id']) ? 'false' : 'true'; ?>;
        linkField.required = false;
        linkField.value = "";
    } 
    
    // ✅ Default (nothing selected)
    else {
        fileInput.style.display = "none";
        linkInput.style.display = "none";
        linkField.required = false;
        fileField.required = false;
    }
}


  // Initialize display
  toggleInputs();

  // On change
  typeSelect.addEventListener('change', toggleInputs);
});
</script>
</body>

</html>