<?php
include("auth.php");
include("../config.php");

if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) die("Invalid CSRF");
$settings = $conn->query("SELECT * FROM settings LIMIT 1")->fetch_assoc();


// If no student selected
if (!isset($_POST['students'])) die("No students selected.");

$ids = implode(",", array_map('intval', $_POST['students']));
$q = $conn->query("SELECT * FROM student WHERE id IN ($ids)");
?>
<!DOCTYPE html>
<html>
<head>
<title>ID Card Preview (A4 Layout)</title>

<style>
body {
    margin: 0;
    padding: 20px;
    background: #f3f3f3;
    font-family: Arial;
}

/* A4 container */
.sheet {
    width: 794px;
    min-height: 1123px;
    background: white;
    padding: 20px;
    margin: auto;
    box-shadow: 0 0 8px rgba(0,0,0,0.4);
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    page-break-after: always;
}

/* EXACT fixed ID card size for 3×3 layout */
.id-card {
    width: 241px;
    height: 351px;
    background-image: url('../<?= $settings['student_id_bg'] ?>');

    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
    border-radius: 8px;
    border: 1px solid #444;
    padding: 4px;             /* ✅ reduced from 6px */
    overflow: hidden;

    display: flex;
    flex-direction: column;
    justify-content: space-between;
}



.id-card table {
    width: 100%;
    padding: 0 12px;     /* ✅ Add horizontal padding */
    margin: 5px 0 0 50px;
}

/* Force text to wrap properly */
.id-card table td {
    word-break: break-word;
    overflow-wrap: break-word;
    white-space: normal;
    max-width: 130px;        /* ✅ Prevent stretching */
    line-height: 1.15;
    font-size: 13px;
    padding: 2px 3px;        /* ✅ small cell padding */
}

/* Photo */
.photo {
    width: 80px;
    height: 80px;
    margin: 14px auto 0 auto;
    border: 3px solid #02317e;
    border-radius: 50%;     /* ✅ Make it round */
    overflow: hidden;
}



.photo img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;    /* ✅ ensure image is also round */
}




.institute {
    font-size: 10px;
    text-align: center;
    margin-bottom: 8px;  /* ✅ consistent distance from bottom */
    padding: 0 8px;
}


@media print {
    body {
        background: white !important;
    }

    .sheet {
        box-shadow: none !important;
        margin: 0;
        padding: 0;
        width: 100%;
        page-break-after: always;
    }
}
/* ✅ Force table text to wrap properly */
.id-card table td {
    word-break: break-word;       /* Wrap long words */
    overflow-wrap: break-word;    /* Modern wrapping */
    white-space: normal;          /* Allow multiple lines */
    max-width: 120px;             /* Prevent table stretching */
    line-height: 1.1;
    font-size: 13px;
}
.id-card table td:last-child {
    display: block;
}
@media print {
    .id-card {
        page-break-inside: avoid;
    }
    .sheet {
        page-break-after: always;
        box-shadow: none !important;
    }
}
.content-area {
    text-align: left;
}

.id-card h4 {
    margin: 12px 0 8px 65px; /* ✅ fixed gap */
    font-size: 14px;
}
.id-card table {
    width: 100%;
    font-size: 12px;
    padding: 0 10px 10px 0;
    margin-top: 5px;   /* ✅ fixed gap after name */
}
.id-card table td {
    word-break: break-word;
    white-space: normal;
    line-height: 1.1;
}
@media print {
    button, .no-print {
        display: none !important;
    }
}
/* ✅ FINAL PRINT FIX FOR 3×3 GRID */
@media print {

    @page {
    size: A4 portrait;
    margin: 4mm 0 0 0;   /* TOP MARGIN FIX */
}


    * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }

    body {
        margin: 0 !important;
        padding: 0 !important;
        background: white !important;
    }

    .sheet {
        width: 794px !important;
        height: 1123px !important;
        padding: 10px !important;
        margin: 0 auto !important;
        box-shadow: none !important;
        display: flex !important;
        flex-wrap: wrap !important;
        gap: 15px !important;
    }

    .id-card {
        width: 241px !important;
        height: 351px !important;
        background-size: cover !important;
        background-repeat: no-repeat !important;
        background-position: center !important;
        page-break-inside: avoid !important;
    }

    button, .no-print {
        display: none !important;
    }
}

/* ✅ Prevent html2pdf from enlarging grid */
.sheet {
    width: 794px !important;
    min-height: 1123px !important;
}

.id-card {
    width: 241px !important;
    height: 351px !important;
    page-break-inside: avoid !important;
}

/* ✅ Forcing page breaks between 9-card sheets */
.sheet {
    page-break-after: always !important;
}


</style>

</head>
<body>
    
<div style="text-align:center; margin-bottom:20px;" class="no-print">
    <button onclick="window.print()" 
        style="padding:10px 20px; background:#4a04c3; color:white; border:none; border-radius:5px; cursor:pointer;">
        Print ID Cards
    </button>

    <!--<button onclick="downloadPDF()" -->
    <!--    style="padding:10px 20px; background:#0a921d; color:white; border:none; border-radius:5px; cursor:pointer;">-->
    <!--    Download PDF-->
    <!--</button>-->
</div>

<div class="sheet">

<?php while ($s = $q->fetch_assoc()) { ?>

<div class="id-card">

  <div class="content-area">
      <div class="logo" style="text-align:center;">
        <img src="<?= htmlspecialchars($settings['logo']) ?>" style="width:200px;">
      </div>
      <div class="photo">
        <img src="./<?= htmlspecialchars($s['photo']) ?>">
      </div>

      <h4><?= htmlspecialchars($s['name']) ?></h4>

      <table>
        <tr ><td><b>Reg:</b></td><td><?= $s['registration_no'] ?></td></tr>
        <tr><td><b>Mob:</b></td><td><?= $s['mobile'] ?></td></tr>
        <tr><td><b>DOB:</b></td><td><?= date("d-m-Y", strtotime($s['dob'])) ?></td></tr>
        <tr><td><b>Email:</b></td><td><?= $s['email'] ?></td></tr>
      </table>
  </div>

  <div class="institute">
    <b><?= $settings['site_name'] ?></b><br>
    <?= nl2br($settings['address']) ?> - <?= $settings['phone'] ?>
  </div>

</div>


<?php } ?>

</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<script>
function downloadPDF() {
    const element = document.querySelector(".sheet");

    const opt = {
        margin: [0, 0, 0, 0],
        filename: 'student-id-cards.pdf',
        image: { type: 'jpeg', quality: 1 },
        html2canvas: { 
            scale: 2,
            useCORS: true,
            letterRendering: true,
            windowWidth: element.scrollWidth
        },
        jsPDF: { 
            unit: 'px', 
            format: [794, 1123],  // ✅ EXACT A4 pixel size
            orientation: 'portrait'
        },
        pagebreak: { 
            mode: ['css', 'legacy'], 
            before: '.sheet'
        }
    };

    html2pdf().set(opt).from(element).save();
}
</script>

</body>
</html>

