<?php  
include("auth.php");
include("../config.php");

// ✅ Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// --- Batch Filter Session Handling ---
if (isset($_GET['batch'])) {
    $_SESSION['batch_filter'] = $_GET['batch'];
}

$batch_filter = $_SESSION['batch_filter'] ?? "all";

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Generate Student ID - <?= htmlspecialchars($settings['site_name'] ?? 'Smart Institute') ?></title>

  <link href="./<?= htmlspecialchars($settings['fevicon']) ?>" rel="icon">
  <link href="./<?= htmlspecialchars($settings['fevicon']) ?>" rel="apple-touch-icon">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">

<style>
/* ✅ ID Card Preview CSS */
.id-card {
  width: 320px;
  height: 500px;
  background-image: url('../<?= htmlspecialchars($settings['student_id_bg']) ?>');
  background-size: cover;
  background-position: center;
  border-radius: 10px;
  padding: 15px;
  color: #000;
  font-family: Arial, sans-serif;
  border: 2px solid #333;
}

.id-card .photo {
  width: 120px;
  height: 140px;
  border: 2px solid #555;
  margin: 0 auto;
  border-radius: 5px;
  overflow: hidden;
}

.id-card .photo img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.id-card h4 {
  text-align: center;
  margin-top: 10px;
  font-weight: bold;
}

.id-card table {
  width: 100%;
  margin-top: 15px;
  font-size: 14px;
}
</style>

</head>

<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

<div class="pagetitle">
  <h1>Generate Student ID</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item active">Student Id</li>
    </ol>
  </nav>
</div>

<?php
// ✅ Fetch current student ID background
$current_bg = $settings['student_id_bg'];
?>

<div class="card mb-4 shadow-sm border-0">
  <div class="card-header  d-flex justify-content-between align-items-center">
    <h5 class="mb-0"> Student ID Card Template</h5>
  </div>

<div class="card-body d-flex align-items-start justify-content-between flex-wrap gap-4" style="row-gap: 2rem;">

  <!-- ✅ Current Template Preview -->
  <div class="text-center mx-auto">
    <p class="mb-2 fw-semibold">Current Template:</p>
    <div class="border rounded shadow-sm bg-light p-2 d-flex align-items-center justify-content-center"
         style="width:200px; height:300px; overflow:hidden;">
      <img src="../<?= htmlspecialchars($current_bg) ?>"
           width="200" height="300"
           class="rounded"
           alt="Current ID Template"
           onerror="this.src='assets/img/no-image.png';">
    </div>
  </div>

  <!-- ✅ Upload & Update Template -->
  <div style="flex:1; min-width:280px; max-width:400px; margin-top:100px;" class=" mx-auto ">
    <form id="updateBgForm" action="update-id-bg.php" method="POST" enctype="multipart/form-data" class="position-relative">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

      <label class="form-label fw-semibold">Upload New ID Template 
        <small class="text-muted">(Recommended: 241×351 px)</small>
      </label>
      <input type="file" name="new_bg" id="new_bg" class="form-control mb-2" accept=".jpg,.jpeg,.png" required>

      <!-- ✅ Progress Bar -->
      <div id="uploadProgressContainer" class="progress mt-3" style="height:8px; display:none;">
        <div id="uploadProgressBar" class="progress-bar progress-bar-striped progress-bar-animated bg-success"
             role="progressbar" style="width:0%"></div>
      </div>

      <!-- ✅ Animated Message -->
      <div id="uploadMessage"
           style="display:none;margin-top:10px;padding:10px;border-radius:5px;font-weight:500;text-align:center;"></div>

      <div class="text-start">
        <button type="submit" class="btn btn-success btn-sm mt-3">
          Upload & Update Background
        </button>
      </div>
    </form>
  </div>

</div>


</div>


<section class="section">
<form id="generateForm" action="student-id-generate.php" method="POST" target="_blank">
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

  <div class="card">
    <div class="card-header">
    
     <div class="mb-2 d-flex align-items-center">
    <label class="me-2"><strong>Batch Filter:</strong></label>
    <select id="batchFilter" class="form-select w-25">
    <option value="all" <?= $batch_filter == "all" ? "selected" : "" ?>>All</option>
    <?php
    $batchQ = $conn->query("SELECT id, title FROM batch WHERE deleted_at IS NULL ORDER BY title ASC");
    while ($b = $batchQ->fetch_assoc()) {
        echo "<option value='{$b['id']}' " . ($batch_filter == $b['id'] ? "selected" : "") . ">{$b['title']}</option>";
    }
    ?>
</select>

   </div>

      <div class="mb-2">
        <strong>Select Students to Generate ID Cards</strong>
      </div>

      <div class="d-flex justify-content-between align-items-center">
        <input type="text" id="searchStudent" class="form-control w-50" placeholder="Search students...">
        <button type="submit" class="btn btn-primary" id="generateBtn">Generate ID</button>
      </div>

    </div>

    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-striped" id="studentTable">
          <thead>
            <tr>
              <th><input type="checkbox" id="checkAll"></th>
              <th>Photo</th>
              <th>Name</th>
              <th>Mobile</th>
              <th>Email</th>
              <th>DOB</th>
            </tr>
          </thead>
          <tbody>
            <?php
            if ($batch_filter == "all") {
             $q = $conn->query("SELECT * FROM student WHERE deleted_at IS NULL ORDER BY id DESC");
            }
             else {
             $q = $conn->query("SELECT student.* FROM student INNER JOIN enrolments ON enrolments.mobile = student.mobile WHERE student.deleted_at IS NULL AND enrolments.bid = '$batch_filter' ORDER BY student.id DESC");

}
            

            while ($row = $q->fetch_assoc()) {
            ?>
            <tr>
              <td><input type="checkbox" name="students[]" value="<?= $row['id'] ?>"></td>
              <td><img src="./<?= htmlspecialchars($row['photo']) ?>" width="60" height="60" class="rounded"></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td><?= htmlspecialchars($row['mobile']) ?></td>
              <td><?= htmlspecialchars($row['email']) ?></td>
              <td><?= date("d-m-Y", strtotime($row['dob'])) ?></td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</form>
</section>

</main>
<?php include("templates/footer.php"); ?>

<a href="#" class="back-to-top d-flex align-items-center justify-content-center">
  <i class="bi bi-arrow-up-short"></i>
</a>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/js/main.js"></script>

<script>

document.getElementById("batchFilter").addEventListener("change", function() {
    let value = this.value;
    window.location = "?batch=" + value;
});

// ✅ Select/Deselect All Students
document.getElementById('checkAll').onclick = function() {
  let checks = document.querySelectorAll("input[name='students[]']");
  checks.forEach(c => c.checked = this.checked);
};

// ✅ Require at least one student selected
document.getElementById("generateForm").addEventListener("submit", function(e) {
  let selected = document.querySelectorAll("input[name='students[]']:checked");
  if (selected.length === 0) {
    e.preventDefault();
    alert("Please select at least one student to generate ID cards.");
  }
});

// ✅ Live Search (reorders matching rows)
document.getElementById("searchStudent").addEventListener("keyup", function() {
  let input = this.value.toLowerCase();
  let rows = Array.from(document.querySelectorAll("#studentTable tbody tr"));
  let matched = [], unmatched = [];

  rows.forEach(row => {
    let text = row.innerText.toLowerCase();
    if (text.includes(input)) matched.push(row);
    else unmatched.push(row);
  });

  let tbody = document.querySelector("#studentTable tbody");
  tbody.innerHTML = "";
  matched.forEach(r => tbody.appendChild(r));
  unmatched.forEach(r => tbody.appendChild(r));
});


// ✅ Upload New Template with Progress Bar + Animated Success
document.getElementById("updateBgForm").addEventListener("submit", function(e) {
  e.preventDefault();

  const form = this;
  const fileInput = document.getElementById("new_bg");
  const file = fileInput.files[0];
  const message = document.getElementById("uploadMessage");
  const progressBarContainer = document.getElementById("uploadProgressContainer");
  const progressBar = document.getElementById("uploadProgressBar");

  if (!file) return;

  const formData = new FormData(form);
  const xhr = new XMLHttpRequest();

  xhr.open("POST", form.action, true);

  // ✅ Show progress bar
  progressBarContainer.style.display = "block";
  progressBar.style.width = "0%";
  message.style.display = "none";

  xhr.upload.onprogress = function(e) {
    if (e.lengthComputable) {
      const percent = Math.round((e.loaded / e.total) * 100);
      progressBar.style.width = percent + "%";
    }
  };

  xhr.onload = function() {
    progressBar.style.width = "100%";

    try {
      const result = JSON.parse(xhr.responseText);
      if (result.success) {
        showAnimatedMessage("Template updated successfully!", "success");

        // Update current template preview
        const reader = new FileReader();
        reader.onload = function(ev) {
          document.querySelector("img[alt='Current ID Template']").src = ev.target.result;
        };
        reader.readAsDataURL(file);
      } else {
        showAnimatedMessage("❌ " + result.message, "danger");
      }
    } catch {
      showAnimatedMessage("❌ Unexpected response. Try again.", "danger");
    }

    // Hide progress bar after 2s
    setTimeout(() => { progressBarContainer.style.display = "none"; }, 2000);
  };

  xhr.send(formData);

  // ✅ Animated Message Function
  function showAnimatedMessage(text, type) {
    message.innerText = text;
    message.style.display = "block";
    message.style.background = type === "success" ? "#d1e7dd" : "#f8d7da";
    message.style.color = type === "success" ? "#0f5132" : "#842029";
    message.style.border = "1px solid " + (type === "success" ? "#badbcc" : "#f5c2c7");

    // Smooth fade-out after 3 seconds
    setTimeout(() => {
      message.style.transition = "opacity 0.8s ease";
      message.style.opacity = "0";
      setTimeout(() => {
        message.style.display = "none";
        message.style.opacity = "1";
      }, 800);
    }, 3000);
  }
});

// ✅ Live Preview before Upload
document.getElementById("new_bg").addEventListener("change", function(event) {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      const preview = document.getElementById("previewImg");
      preview.src = e.target.result;
      preview.style.display = "block";
    };
    reader.readAsDataURL(file);
  }
});
</script>
</body>
</html>
