<?php
include("auth.php");
require "../config.php";

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Security headers
header("Content-Type: application/json");
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");

// CSRF check
// Check if the CSRF token exists in the session and the POST request
if (!isset($_POST['csrftoken']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrftoken'])) {
    // If CSRF token is invalid, send an error response
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

// Process form data on POST request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $enquiry_id = $_POST['enquiry_id'];
    $user_id = $_POST['user_id'];
    $notes = $_POST['notes'];
    $followup_date = $_POST['followup_date'];
    $next_action_date = $_POST['next_action_date'];
    $status = $_POST['status'];

    // Sanitize the input data
    $notes = mysqli_real_escape_string($conn, $notes);
    $next_action_date = mysqli_real_escape_string($conn, $next_action_date);
    $status = mysqli_real_escape_string($conn, $status);
    $followup_date = mysqli_real_escape_string($conn, $followup_date);

    // Insert the follow-up into the database
    $sql_followup = "INSERT INTO followups (enquiry_id, user_id, notes, followup_date, next_action_date, status) 
                     VALUES ('$enquiry_id', '$user_id', '$notes', '$followup_date', '$next_action_date', '$status')";

    if (mysqli_query($conn, $sql_followup)) {
    // Follow-up inserted successfully
    $sql_update_enquiry = "UPDATE enquiries SET status = '$status' WHERE enquiry_id = '$enquiry_id'";

    if (mysqli_query($conn, $sql_update_enquiry)) {
        echo json_encode(["status" => "success", "message" => "Follow-up added successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to update enquiry status"]);
    }
} else {
        echo json_encode(["status" => "error", "message" => "Failed to add follow-up: " . mysqli_error($conn)]);

}

}
?>



