<?php
include("../config.php");
if (session_status() === PHP_SESSION_NONE) session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ✅ CSRF Protection
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die("Invalid CSRF token.");
    }

    // ✅ Sanitize Inputs
    $details  = trim($_POST['subscription_details']);
    $validity = trim($_POST['subscription_validity']);
    $amount   = floatval($_POST['subscription_amount']);

    // ✅ Update Query
    $stmt = $conn->prepare("
        UPDATE settings 
        SET subscription_details = ?, 
            subscription_validity = ?, 
            subscription_amount = ? 
        WHERE id = 1
    ");
    $stmt->bind_param("ssd", $details, $validity, $amount); // d = double (for decimal/float)

    // ✅ Execution and Flash Message
    if ($stmt->execute()) {
        $_SESSION['flash'] = [
            'type' => 'success',
            'msg' => 'Subscription Plan Updated Successfully!'
        ];
    } else {
        $_SESSION['flash'] = [
            'type' => 'danger',
            'msg' => 'Error updating subscription plan.'
        ];
    }

    // ✅ Redirect Back
    header("Location: subscription_plan_settings.php");
    exit;
}
?>
