<?php  
include("auth.php");
include("../config.php");

// Fetch settings (single row)
$sql = "SELECT * FROM settings LIMIT 1";
$result = $conn->query($sql);
$settings = $result->fetch_assoc();

// CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Subscription Plan Settings - <?= htmlspecialchars($settings['site_name']); ?></title>

  <!-- Favicons -->
  <link href="./<?= htmlspecialchars($settings['fevicon']); ?>" rel="icon">
  <link href="./<?= htmlspecialchars($settings['fevicon']); ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Subscription Settings</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">Subscription  Settings</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <div class="card shadow-sm">
            <div class="card-body pt-4">
                
                <?php if (!empty($_SESSION['flash'])): ?>
  <div class="alert alert-<?= htmlspecialchars($_SESSION['flash']['type']); ?> alert-dismissible fade show" role="alert">
  <?= htmlspecialchars($_SESSION['flash']['msg']); ?>
  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>

  <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

              <form id="subscription_settings" action="subscription-plan-action.php" method="POST">
                
                <!-- Subscription Details (with editor) -->
                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Subscription Details</label>
                  <div class="col-sm-10">
                    <div id="subscription_details_editor" class="form-control" style="height: 200px; overflow-y:auto;">
                      <?= htmlspecialchars_decode($settings['subscription_details'] ?? '') ?>
                    </div>
                    <input type="hidden" name="subscription_details" id="subscription_details">
                  </div>
                </div>

                <!-- Subscription Amount -->
                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Subscription Amount (₹)</label>
                  <div class="col-sm-10">
                    <input type="number" step="0.01" name="subscription_amount" id="subscription_amount" 
                      class="form-control" value="<?= htmlspecialchars($settings['subscription_amount'] ?? '') ?>" required>
                  </div>
                </div>

                <!-- Subscription Validity -->
                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Subscription Validity</label>
                  <div class="col-sm-10">
                    <select name="subscription_validity" id="subscription_validity" class="form-select">
                      <option value="">-- Select Validity --</option>
                      <option value="6 Months" <?= ($settings['subscription_validity'] == '6 Months') ? 'selected' : ''; ?>>6 Months</option>
                      <option value="1 Year" <?= ($settings['subscription_validity'] == '1 Year') ? 'selected' : ''; ?>>1 Year</option>
                    </select>
                  </div>
                </div>

                <!-- Submit -->
                <div class="row mb-3">
                  <div class="col-sm-10 offset-sm-2">
                    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token']; ?>">
                    <button type="submit" class="btn btn-primary">
                       Update Settings
                    </button>
                  </div>
                </div>

              </form>

            </div>
          </div>
        </div>
      </div>
    </section>
  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
  <script src="assets/js/main.js"></script>

  <!-- Quill Editor Init -->
  <script>
    var quill = new Quill('#subscription_details_editor', {
      theme: 'snow',
      placeholder: 'Enter subscription details...',
      modules: {
        toolbar: [
          [{ 'header': [1, 2, false] }],
          ['bold', 'italic', 'underline', 'strike'],
          [{ 'list': 'ordered' }, { 'list': 'bullet' }],
          ['link', 'clean']
        ]
      }
    });

    document.querySelector('form').onsubmit = function() {
      document.querySelector('#subscription_details').value = quill.root.innerHTML;
    };
  </script>
<script>
  setTimeout(() => {
    const alert = document.querySelector('.alert');
    if (alert) {
      alert.classList.add('fade'); // add fade-out effect
      alert.classList.remove('show');
      setTimeout(() => alert.remove(), 500); // remove from DOM after fade
    }
  }, 3000);
</script>


</body>
</html>
