<?php

if (isset($_SESSION['created_time']) && (time() - $_SESSION['created_time'] > $maxLifetime)) {
    destroy_session_and_cookie(); exit;
}

// inactivity check
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $inactiveLimit)) {
    destroy_session_and_cookie(); exit;
}

$_SESSION['last_activity'] = time(); 

$userId = $_SESSION['user_id'];
// User Fetch 
$stmt = $conn->prepare("SELECT * FROM `users` WHERE `user_id` = ? AND `deleted_at` IS NULL LIMIT 1");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$users = $result->fetch_assoc();

if (!empty($settings['validity'])) {
    $today = date("Y-m-d");
    $validity = $settings['validity'];

    if ($today > $validity) {
        header("Location: ../expired.php");
        exit();
    }
}

?>
<!-- ======= Header ======= -->
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="dashboard.php" class="logo d-flex align-items-center">
        <span class="d-none d-lg-block fs-5" ><?php echo $settings['site_name']; ?></span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

      <!-- Mobile Centered Site Name -->
  <div class="mobile-site-name text-center flex-grow-1 d-lg-none">
    <span class="fw-bold text-primary"><?php echo $settings['site_name']; ?></span>
  </div>
  <!-- End Mobile Centered Site Name -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">


        <li class="nav-item dropdown pe-3">

          <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
            <img src="./<?php echo $users['profile_image']; ?>" alt="Profile" class="rounded-circle">
            <!--<span class="d-none d-md-block dropdown-toggle ps-2">K. Anderson</span>-->
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header">
              <h6><?php echo $users['name']; ?></h6>
              <span><?php echo $users['role']; ?></span>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="profile.php">
                <i class="bi bi-person-circle"></i>
                <span>My Profile</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="change-password.php">
                <i class="bi bi-person-lock"></i>
                <span>Change Password</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="help.php">
                <i class="bi bi-question-circle"></i>
                <span>Need Help ?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="logout.php">
                <i class="bi bi-box-arrow-right"></i>
                <span>Sign Out</span>
              </a>
            </li>

          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->

      </ul>
    </nav><!-- End Icons Navigation -->

  </header><!-- End Header -->
