<?php
$currentPage = basename($_SERVER['PHP_SELF']);
function isActive($pages) {
  global $currentPage;
  return in_array($currentPage, $pages);
}
?>
<style>
    /* BASE LINK STYLE */
.sidebar .nav-link,
.sidebar .nav-content a {
    background: #f0f6ff !important;      /* Light blue */
    color: #333 !important;
    border-radius: 6px;
    margin-bottom: 6px;
    transition: 0.2s;
    padding: 12px 15px;
}

/* HOVER */
.sidebar .nav-link:hover,
.sidebar .nav-content a:hover {
    background: #dceaff !important;
}

/* ACTIVE (top-level OR child) */
.sidebar .nav-link.active,
.sidebar .nav-content a.active {
    background: #7fb6d2 !important;      /* Dark blue */
    color: #fff !important;
}

/* MAKE DROPDOWN CONTAINER CLEAN */
.sidebar .nav-content {
    padding-left: 20px;
}

/* ICON COLOR FIX */
.sidebar i {
    color: inherit !important;
}

</style>

<!-- ======= Sidebar ======= -->
<!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">

<ul class="sidebar-nav" id="sidebar-nav">

  <!-- Dashboard -->
  <li class="nav-item">
    <a class="nav-link <?= $currentPage=='dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
      <i class="bi bi-speedometer2"></i>
      <span>Dashboard</span>
    </a>
  </li>

  <!-- Website -->
  <?php $webPages = ['notices.php','contents.php','medias.php','testimonials.php','faqs.php','gallery.php','services.php','courses.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($webPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#website-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-globe"></i><span>Website</span>
      <i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="website-nav" class="nav-content collapse <?= isActive($webPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="notices.php" class="<?= $currentPage=='notices.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Notice</span></a></li>
      <li><a href="contents.php" class="<?= $currentPage=='contents.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Content</span></a></li>
      <li><a href="medias.php" class="<?= $currentPage=='medias.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Media</span></a></li>
      <li><a href="services.php" class="<?= $currentPage=='services.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Services</span></a></li>
      <li><a href="courses.php" class="<?= $currentPage=='courses.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Courses</span></a></li>
      <li><a href="gallery.php" class="<?= $currentPage=='gallery.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Gallery</span></a></li>
      <li><a href="testimonials.php" class="<?= $currentPage=='testimonials.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Testimonials</span></a></li>
      <li><a href="faqs.php" class="<?= $currentPage=='faqs.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>FAQ</span></a></li>
    </ul>
  </li>

  <!-- Enquiry -->
  <?php $enqPages = ['enquiries.php','followups.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($enqPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#enquiry-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-chat-dots"></i><span>Enquiry</span><i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="enquiry-nav" class="nav-content collapse <?= isActive($enqPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="enquiries.php" class="<?= $currentPage=='enquiries.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Enquiries</span></a></li>
      <li><a href="followups.php" class="<?= $currentPage=='followups.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Follow Ups</span></a></li>
    </ul>
  </li>

  <!-- Student Corner -->
  <?php $studentPages = ['student-corner-library.php','registeration.php','subscribers.php','activity_logs.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($studentPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#student-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-person-lines-fill"></i><span>Student Corner</span><i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="student-nav" class="nav-content collapse <?= isActive($studentPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="student-corner-library.php" class="<?= $currentPage=='student-corner-library.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Uploads</span></a></li>
      <li><a href="registeration.php" class="<?= $currentPage=='registeration.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Registration</span></a></li>
      <li><a href="subscribers.php" class="<?= $currentPage=='subscribers.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Subscriptions</span></a></li>
      <li><a href="activity_logs.php" class="<?= $currentPage=='activity_logs.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Students Activity Log</span></a></li>
    </ul>
  </li>

  <!-- Institute Management -->
  <?php $imsPages = ['batches.php','students.php','student-id.php','enrolements.php','attendance.php','fees.php','user-id-card.php','certificate.php','references.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($imsPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#ims-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-building"></i><span>Institute Management</span><i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="ims-nav" class="nav-content collapse <?= isActive($imsPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="students.php" class="<?= $currentPage=='students.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Students</span></a></li>
      <li><a href="student-id.php" class="<?= $currentPage=='student-id.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Student ID Card</span></a></li>
      <li><a href="enrolements.php" class="<?= $currentPage=='enrolements.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Enrolments</span></a></li>
      <li><a href="attendance.php" class="<?= $currentPage=='attendance.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Attendance</span></a></li>
      <li><a href="fees.php" class="<?= $currentPage=='fees.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Fees</span></a></li>
      <li><a href="batches.php" class="<?= $currentPage=='batches.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Batches</span></a></li>
      <li><a href="certificate.php" class="<?= $currentPage=='certificate.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Certificate</span></a></li>
      <li><a href="user-id-card.php" class="<?= $currentPage=='user-id-card.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Employee Cards</span></a></li>
      <li><a href="references.php" class="<?= $currentPage=='references.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Enquiry References</span></a></li>
    </ul>
  </li>

  <!-- Expense Register -->
  <li class="nav-item">
    <a class="nav-link <?= $currentPage=='expenses.php'?'active':'' ?>" href="expenses.php">
      <i class="bi bi-receipt"></i><span>Expense Register</span>
    </a>
  </li>
  
  <!-- Blogs -->
<?php $blogPages = ['blog-categories.php','blog-posts.php']; ?>
<li class="nav-item">
  <a class="nav-link <?= isActive($blogPages) ? 'active' : 'collapsed' ?>"
     data-bs-target="#blogs-nav" data-bs-toggle="collapse" href="#">
    <i class="bi bi-journal-text"></i><span>Blogs</span><i class="bi bi-chevron-down ms-auto"></i>
  </a>

  <ul id="blogs-nav" class="nav-content collapse <?= isActive($blogPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">

    <li>
      <a href="blog-categories.php" class="<?= $currentPage=='blog-categories.php' ? 'active' : '' ?>">
        <i class="bi bi-circle"></i><span>Categories</span>
      </a>
    </li>

    <li>
      <a href="blog-posts.php" class="<?= $currentPage=='blog-posts.php' ? 'active' : '' ?>">
        <i class="bi bi-circle"></i><span>Posts</span>
      </a>
    </li>

  </ul>
</li>


  <!-- Reports -->
  <?php $reportPages = ['enrollment-reports.php','attendance-reports.php','fee-reports.php','expense-reports.php','fundflow-reports.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($reportPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#reports-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-graph-up"></i><span>Reports</span><i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="reports-nav" class="nav-content collapse <?= isActive($reportPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="enrollment-reports.php" class="<?= $currentPage=='enrollment-reports.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Enrolment Report</span></a></li>
      <li><a href="attendance-reports.php" class="<?= $currentPage=='attendance-reports.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Attendance Report</span></a></li>
      <li><a href="fee-reports.php" class="<?= $currentPage=='fee-reports.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Fee Report</span></a></li>
      <li><a href="expense-reports.php" class="<?= $currentPage=='expense-reports.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Expense Report</span></a></li>
      <li><a href="fundflow-reports.php" class="<?= $currentPage=='fundflow-reports.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Fund Flow Report</span></a></li>
    </ul>
  </li>

  <!-- Settings -->
  <?php $settingsPages = ['settings.php','website-settings.php','seo-settings.php','email-settings.php','subscription_plan_settings.php','qr_code.php', 'ad_settings.php']; ?>
  <li class="nav-item">
    <a class="nav-link <?= isActive($settingsPages) ? 'active' : 'collapsed' ?>"
       data-bs-target="#settings-nav" data-bs-toggle="collapse" href="#">
      <i class="bi bi-gear"></i><span>Settings</span><i class="bi bi-chevron-down ms-auto"></i>
    </a>

    <ul id="settings-nav" class="nav-content collapse <?= isActive($settingsPages) ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
      <li><a href="settings.php" class="<?= $currentPage=='settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>General Settings</span></a></li>
      <li><a href="website-settings.php" class="<?= $currentPage=='website-settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Website Settings</span></a></li>
      <li><a href="seo-settings.php" class="<?= $currentPage=='seo-settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>SEO Settings</span></a></li>
      <li><a href="email-settings.php" class="<?= $currentPage=='email-settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Email Settings</span></a></li>
      <li><a href="subscription_plan_settings.php" class="<?= $currentPage=='subscription_plan_settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Subscription Settings</span></a></li>
      <li><a href="qr_code.php" class="<?= $currentPage=='qr_code.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>QR Codes</span></a></li>
      <li><a href="ad_settings.php" class="<?= $currentPage=='ad_settings.php'?'active':'' ?>"><i class="bi bi-circle"></i><span>Ads Settings</span></a></li>
    </ul>
  </li>

  <!-- Newsletter -->
  <li class="nav-item">
    <a class="nav-link <?= $currentPage=='newsletters.php'?'active':'' ?>" href="newsletters.php">
      <i class="bi bi-envelope-paper"></i><span>Newsletter</span>
    </a>
  </li>

  <!-- Admin Only -->
  <?php if($_SESSION['role']=='Admin' || $_SESSION['role']=='') { ?>

  <li class="nav-item">
    <a class="nav-link <?= $currentPage=='feedback.php'?'active':'' ?>" href="feedback.php">
      <i class="bi bi-chat-left-quote"></i><span>Feedback</span>
    </a>
  </li>

  <li class="nav-item">
    <a class="nav-link <?= $currentPage=='users.php'?'active':'' ?>" href="users.php">
      <i class="bi bi-people-fill"></i><span>Users</span>
    </a>
  </li>

  <?php } ?>

</ul>

</aside>
<!-- End Sidebar -->


