<?php
include("../config.php");
include("auth.php");

header('Content-Type: application/json');

// CSRF check
if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo json_encode(['success' => false, 'message' => 'Invalid CSRF token']);
    exit;
}

$template_type = $_POST['template_type'] ?? '';
if (!isset($_FILES['new_bg']) || $_FILES['new_bg']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'File upload error']);
    exit;
}

// Allowed extensions
$allowed = ['jpg','jpeg','png','webp'];
$ext = strtolower(pathinfo($_FILES['new_bg']['name'], PATHINFO_EXTENSION));
if (!in_array($ext, $allowed)) {
    echo json_encode(['success' => false, 'message' => 'Invalid file type']);
    exit;
}

// Move file
$targetDir = "../uploads/templates/";
if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);

$filename = $template_type.'_'.time().'.'.$ext;
$targetFile = $targetDir.$filename;

if (move_uploaded_file($_FILES['new_bg']['tmp_name'], $targetFile)) {
    // Update in DB
    $stmt = $conn->prepare("UPDATE settings SET $template_type=? WHERE id=1");
    $stmt->bind_param("s", $targetFile);
    $stmt->execute();

    echo json_encode(['success' => true, 'message' => 'Template updated successfully']);
    exit;
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to move uploaded file']);
    exit;
}
?>
