<?php
header('Content-Type: application/json');
include("../config.php");
session_start();

$response = ['success' => false, 'message' => 'Something went wrong.'];

// ✅ CSRF validation
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    echo json_encode(['success' => false, 'message' => 'CSRF validation failed.']);
    exit;
}

// ✅ File validation
if (!isset($_FILES['new_bg']) || $_FILES['new_bg']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'No file uploaded or upload error.']);
    exit;
}

// ✅ Directory setup
$uploadDir = "../assets/img/id-templates/";
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// ✅ Create unique filename
$fileTmp = $_FILES['new_bg']['tmp_name'];
$ext = pathinfo($_FILES['new_bg']['name'], PATHINFO_EXTENSION);
$cleanExt = strtolower($ext);

// Allowed extensions check
$allowed = ['jpg', 'jpeg', 'png'];
if (!in_array($cleanExt, $allowed)) {
    echo json_encode(['success' => false, 'message' => 'Invalid file type. Only JPG, JPEG, or PNG allowed.']);
    exit;
}

$fileName = time() . "_id-card-bg." . $cleanExt;
$targetPath = $uploadDir . $fileName;

// ✅ Move uploaded file
if (move_uploaded_file($fileTmp, $targetPath)) {

    // Store relative path (without "../")
    $relativePath = "assets/img/id-templates/" . $fileName;

    // ✅ Update settings table (update row with id=1)
    $stmt = $conn->prepare("UPDATE settings SET student_id_bg = ? WHERE id = 1");
    $stmt->bind_param("s", $relativePath);

    if ($stmt->execute()) {
        $response = [
            'success' => true,
            'message' => 'ID card background updated successfully!'
        ];
    } else {
        $response['message'] = 'Database update failed: ' . $stmt->error;
    }

    $stmt->close();
} else {
    $response['message'] = 'File upload failed.';
}

echo json_encode($response);
?>
