<?php
header('Content-Type: application/json');
include('../config.php'); // your DB / config file
session_start();

$response = ['success' => false, 'message' => 'No image uploaded'];

if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
    $file = $_FILES['image'];

    // Validate file type
    $allowed = ['image/jpeg', 'image/png', 'image/gif'];
    if (!in_array($file['type'], $allowed)) {
        $response['message'] = 'Only JPG, PNG, and GIF images are allowed.';
        echo json_encode($response);
        exit;
    }

    // Generate unique filename
    $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    $filename = 'img_' . time() . '_' . rand(1000,9999) . '.' . $ext;

    // Save folder (make sure it's writable)
    $uploadDir = '../uploads/content_images/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $filepath = $uploadDir . $filename;

    if (move_uploaded_file($file['tmp_name'], $filepath)) {
        // Return URL relative to your project root
        $url = '/uploads/content_images/' . $filename;

        $response = [
            'success' => true,
            'message' => 'Image uploaded successfully',
            'url' => '../'.$url
        ];
    } else {
        $response['message'] = 'Failed to move uploaded file.';
    }
} else {
    $response['message'] = 'No file uploaded or upload error.';
}

echo json_encode($response);
exit;
?>
