<?php  
include("auth.php");
include("../config.php");

// ✅ Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// ✅ Handle Template Update Logic (replaces update-id-bg.php)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['template_type'])) {
    header('Content-Type: application/json');
    $response = ['success' => false, 'message' => ''];

    if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Invalid CSRF token.';
        echo json_encode($response);
        exit;
    }

    $uploadDir = "../assets/img/id-templates/";
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    $field = $_POST['template_type'];
    if (!empty($_FILES['new_bg']['name'])) {
        $fileName = time() . "_" . basename($_FILES["new_bg"]["name"]);
        $targetFile = $uploadDir . $fileName;
        $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

        if (in_array($fileType, ['jpg', 'jpeg', 'png', 'webp'])) {
            if (move_uploaded_file($_FILES["new_bg"]["tmp_name"], $targetFile)) {
                $pathToSave = "assets/img/id-templates/" . $fileName;

                // Determine correct column
                if ($field === "employee_id_bg") {
    $stmt = $conn->prepare("UPDATE settings SET employee_id_bg = ? WHERE id = 1");
} elseif ($field === "employee_visiting_bg") {
    $stmt = $conn->prepare("UPDATE settings SET visiting_card_bg = ? WHERE id = 1");
} else {
    $response['message'] = 'Invalid template type.';
    echo json_encode($response);
    exit;
}


                $stmt->bind_param("s", $pathToSave);
                if ($stmt->execute()) {
                    $response['success'] = true;
                    $response['message'] = 'Template updated successfully!';
                } else {
                    $response['message'] = 'Database update failed.';
                }
            } else {
                $response['message'] = 'Error uploading file.';
            }
        } else {
            $response['message'] = 'Invalid file format. Only JPG, PNG, WEBP allowed.';
        }
    } else {
        $response['message'] = 'No file selected.';
    }

    echo json_encode($response);
    exit;
}

// ✅ Fetch current settings
$settingsQuery = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($settingsQuery);
$settings = $result->fetch_assoc();

$current_emp_bg = $settings['employee_id_bg'] ?? '';
$current_vis_bg = $settings['visiting_card_bg'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title>Employee ID & Visiting Card - <?= htmlspecialchars($settings['site_name'] ?? 'Smart Institute') ?></title>

<link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
<link href="assets/css/style.css" rel="stylesheet">

<style>
.preview-box {
  width: 200px;
  height: 300px;
  border-radius: 8px;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
  border: 2px solid #ccc;
  background: #f8f9fa;
}
.preview-box img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}
#uploadMessage { display:none; margin-top:10px; padding:10px; border-radius:5px; font-weight:500; text-align:center; }

@media (max-width: 768px) {
  .preview-box {
    width: 180px !important;
    height: auto !important;
  }
  .card h6 {
    font-size: 1rem;
  }
  .btn-sm {
    width: 100%;
  }
}
.card-body .card {
  transition: all 0.3s ease-in-out;
  border-radius: 12px;
}
.card-body .card:hover {
  transform: translateY(-4px);
  box-shadow: 0 4px 14px rgba(0, 0, 0, 0.1);
}
.preview-box {
  border: 2px dashed #ccc;
  border-radius: 8px;
  background: #f8f9fa;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
}
.preview-box img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

</style>
</head>
<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

<div class="pagetitle">
  <h1>Employee ID & Visiting Card</h1>
</div>

<!-- ✅ Template Update Section -->
<div class="card mb-4 shadow-sm border-0">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h5 class="mb-0">Manage Employee Card Templates</h5>
  </div>

 <div class="card-body">
  <div class="row g-4 justify-content-center align-items-stretch">

    <!-- ✅ Employee ID Template -->
    <div class="col-lg-5 col-md-6 col-sm-10">
      <div class="card h-100 shadow-sm border-0 text-center p-3">
        <h6 class="fw-semibold mb-3">Current Employee ID Template</h6>
        <div class="preview-box mx-auto mb-3" style="width:220px; height:300px;">
          <img src="../<?= htmlspecialchars($current_emp_bg) ?>" alt="Employee ID Template"
               onerror="this.src='assets/img/no-image.png';">
        </div>

        <form class="update-template-form" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
          <input type="hidden" name="template_type" value="employee_id_bg">

          <label class="form-label fw-semibold mb-1">Upload New Employee ID Template(241*351)</label>
          <input type="file" name="new_bg" class="form-control mb-2" accept=".jpg,.jpeg,.png,.webp" required>

          <div class="progress mt-2" style="height:8px; display:none;">
            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width:0%"></div>
          </div>
          <div class="upload-message"></div>

          <button type="submit" class="btn btn-success btn-sm mt-3 px-4">
            <i class="bi bi-upload me-1"></i>Upload & Update
          </button>
        </form>
      </div>
    </div>

    <!-- ✅ Visiting Card Template -->
    <div class="col-lg-5 col-md-6 col-sm-10">
      <div class="card h-100 shadow-sm border-0 text-center p-3">
        <h6 class="fw-semibold mb-3">Current Visiting Card Template</h6>
        <div class="preview-box mx-auto mb-3" style="width:280px; height:160px;">
          <img src="../<?= htmlspecialchars($current_vis_bg) ?>" alt="Visiting Card Template"
               onerror="this.src='assets/img/no-image.png';">
        </div>

        <form class="update-template-form" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
          <input type="hidden" name="template_type" value="employee_visiting_bg">

          <label class="form-label fw-semibold mb-1">Upload New Visiting Card Template(1050 x 600)</label>
          <input type="file" name="new_bg" class="form-control mb-2" accept=".jpg,.jpeg,.png,.webp" required>

          <div class="progress mt-2" style="height:8px; display:none;">
            <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary" style="width:0%"></div>
          </div>
          <div class="upload-message"></div>

          <button type="submit" class="btn btn-primary btn-sm mt-3 px-4">
            <i class="bi bi-upload me-1"></i>Upload & Update
          </button>
        </form>
      </div>
    </div>

  </div>
</div>


<!-- ✅ Employee Selection Section -->
<section class="section">
<form method="POST" target="_blank">
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
  <div class="card">
    <div class="card-header">
      <div class="mb-2">
        <strong>Select Employee to Generate Cards</strong>
      </div>
      <div class="d-flex justify-content-between align-items-center">
        <input type="text" id="searchEmployee" class="form-control w-50" placeholder="Search employee/users...">
        <div class="d-flex gap-2">
          <button type="submit" formaction="employee-id-generate.php" class="btn btn-primary">Generate ID Card</button>
          <button type="submit" formaction="employee-visiting-card.php" class="btn btn-success">Generate Visiting Card</button>
        </div>
      </div>
    </div>

    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-striped" id="employeeTable">
          <thead>
            <tr>
              <th><input type="checkbox" id="checkAll"></th>
              <th>Photo</th>
              <th>Name</th>
              <th>Mobile</th>
              <th>Email</th>
              <th>Role</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $q = $conn->query("SELECT * FROM users WHERE deleted_at IS NULL ORDER BY user_id DESC");
            while ($row = $q->fetch_assoc()) {
            ?>
            <tr>
              <td><input type="checkbox" name="employees[]" value="<?= $row['user_id'] ?>"></td>
              <td><img src="./<?= htmlspecialchars($row['profile_image']) ?>" width="60" height="60" class="rounded"></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td><?= htmlspecialchars($row['phone']) ?></td>
              <td><?= htmlspecialchars($row['email']) ?></td>
              <td><?= htmlspecialchars($row['role']) ?></td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</form>
</section>

</main>
<?php include("templates/footer.php"); ?>

<a href="#" class="back-to-top d-flex align-items-center justify-content-center">
  <i class="bi bi-arrow-up-short"></i>
</a>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/js/main.js"></script>
<script>
// ✅ Select All Toggle
document.getElementById('checkAll').onclick = function() {
  document.querySelectorAll("input[name='employees[]']").forEach(c => c.checked = this.checked);
};

// ✅ Require at least one employee
document.querySelector("form[target='_blank']").addEventListener("submit", function(e) {
  if (document.querySelectorAll("input[name='employees[]']:checked").length === 0) {
    e.preventDefault();
    alert("Please select at least one employee to generate card.");
  }
});

// ✅ Search
document.getElementById("searchEmployee").addEventListener("keyup", function() {
  let input = this.value.toLowerCase();
  let rows = Array.from(document.querySelectorAll("#employeeTable tbody tr"));
  let tbody = document.querySelector("#employeeTable tbody");
  tbody.innerHTML = "";
  rows.sort((a, b) => {
    let aMatch = a.innerText.toLowerCase().includes(input);
    let bMatch = b.innerText.toLowerCase().includes(input);
    return bMatch - aMatch;
  });
  rows.forEach(r => tbody.appendChild(r));
});

// ✅ Template Upload AJAX
document.querySelectorAll(".update-template-form").forEach(form => {
  const progress = form.querySelector(".progress");
  const bar = form.querySelector(".progress-bar");
  const message = form.querySelector(".upload-message");
  const img = form.parentElement.querySelector("img");

  form.addEventListener("submit", function(e) {
    e.preventDefault();
    const file = form.querySelector("input[name='new_bg']").files[0];
    if (!file) return;

    const formData = new FormData(form);
    const xhr = new XMLHttpRequest();
    xhr.open("POST", "", true); // same file

    progress.style.display = "block";
    bar.style.width = "0%";
    message.style.display = "none";

    xhr.upload.onprogress = e => {
      if (e.lengthComputable) bar.style.width = Math.round((e.loaded / e.total) * 100) + "%";
    };

    xhr.onload = () => {
      bar.style.width = "100%";
      try {
        const result = JSON.parse(xhr.responseText);
        if (result.success) {
          showMessage(result.message, "success");
          const reader = new FileReader();
          reader.onload = ev => img.src = ev.target.result;
          reader.readAsDataURL(file);
        } else showMessage("❌ " + result.message, "danger");
      } catch { showMessage("❌ Unexpected error", "danger"); }
      setTimeout(() => progress.style.display = "none", 2000);
    };
    xhr.send(formData);

    function showMessage(text, type) {
      message.textContent = text;
      message.style.display = "block";
      message.style.background = type === "success" ? "#d1e7dd" : "#f8d7da";
      message.style.color = type === "success" ? "#0f5132" : "#842029";
      message.style.border = "1px solid " + (type === "success" ? "#badbcc" : "#f5c2c7");
      setTimeout(() => {
        message.style.transition = "opacity 0.8s ease";
        message.style.opacity = "0";
        setTimeout(() => { message.style.display = "none"; message.style.opacity = "1"; }, 800);
      }, 3000);
    }
  });
});
</script>
</body>
</html>
