<?php  include ("auth.php");
include ("../config.php");

// Fetch settings
$sql = "SELECT * FROM settings LIMIT 1"; // Assuming only one row of settings
$result = $conn->query($sql);
$settings = $result->fetch_assoc();

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Website Settings - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

  <?php include("templates/header.php");?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Website Settings</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Website Settings</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-body pt-5">

<form id="settings_website" enctype="multipart/form-data" action="settings-action.php" method="POST">
  
    <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Logo</label>
    <div class="col-sm-10">
      <?php if (!empty($settings['logo'])): ?>
        <img src="./<?= htmlspecialchars($settings['logo']) ?>" width="80" alt="Logo" class="mb-2">
      <?php endif; ?>
      <input type="file" name="logo" class="form-control">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Logo Light</label>
    <div class="col-sm-10">
      <?php if (!empty($settings['logo_light'])): ?>
        <img src="./<?= htmlspecialchars($settings['logo_light']) ?>" width="80" alt="Logo Light" class="mb-2">
      <?php endif; ?>
      <input type="file" name="logo_light" class="form-control">
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Favicon</label>
    <div class="col-sm-10">
      <?php if (!empty($settings['fevicon'])): ?>
        <img src="./<?= htmlspecialchars($settings['fevicon']) ?>" width="40" alt="Favicon" class="mb-2">
      <?php endif; ?>
      <input type="file" name="fevicon" class="form-control">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Login Background</label>
    <div class="col-sm-10">
      <?php if (!empty($settings['login_background'])): ?>
        <img src="./<?= htmlspecialchars($settings['login_background']) ?>" width="40" alt="Login Background" class="mb-2">
      <?php endif; ?>
      <input type="file" name="login_background" class="form-control">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Developer</label>
    <div class="col-sm-10">
      <input type="text" name="developer" id="developer" placeholder="Enter Developer Name" class="form-control" value="<?= htmlspecialchars($settings['developer']) ?>" >
    </div>
  </div>

  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Developer Website</label>
    <div class="col-sm-10">
      <input type="text" name="developer_website" id="developer_website" placeholder="Enter Developer's Website url" class="form-control" value="<?= htmlspecialchars($settings['developer_website']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Google Map</label>
    <div class="col-sm-10">
      <input type="text" name="google_map" id="google_map" placeholder="Enter google map link/url" class="form-control" value="<?= htmlspecialchars($settings['google_map']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
  <label class="col-sm-2 col-form-label">Location Coordinates</label>
  <div class="col-sm-10">
    <div class="input-group">
      <input type="text" name="latitude" id="latitude" class="form-control" placeholder="Latitude" 
             value="<?= htmlspecialchars($settings['latitude'] ?? '') ?>">
      <input type="text" name="longitude" id="longitude" class="form-control" placeholder="Longitude" 
             value="<?= htmlspecialchars($settings['longitude'] ?? '') ?>">
      <button type="button" class="btn btn-outline-primary" onclick="getLiveLocation()">
        📍 Get Live Location
      </button>
    </div>
    <small class="text-muted d-block mt-1">
      You can manually enter coordinates or use your current location.
    </small>
  </div>
</div>

<script>
function getLiveLocation() {
  if (!navigator.geolocation) {
    alert("Geolocation is not supported by your browser.");
    return;
  }

  const btn = event.target;
  btn.disabled = true;
  btn.innerText = "Getting location...";

  navigator.geolocation.getCurrentPosition(
    position => {
      document.getElementById('latitude').value = position.coords.latitude.toFixed(6);
      document.getElementById('longitude').value = position.coords.longitude.toFixed(6);
      btn.disabled = false;
      btn.innerText = "📍 Get Live Location";
    },
    error => {
      alert("Unable to fetch location. Please allow location access and try again.");
      console.error("Location error:", error);
      btn.disabled = false;
      btn.innerText = "📍 Get Live Location";
    }
  );
}
</script>

  
  
  <div class="row mb-3">
  <label class="col-sm-2 col-form-label">Google Review</label>
  <div class="col-sm-10">
    <textarea 
      name="google_review" 
      id="google_review" 
      class="form-control" 
      rows="3" 
      placeholder="Enter Google review link or URL"><?= htmlspecialchars($settings['google_review']) ?></textarea>
  </div>
</div>

  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Facebook</label>
    <div class="col-sm-10">
      <input type="text" name="facebook" id="facebook" placeholder="Enter Facebook link" class="form-control" value="<?= htmlspecialchars($settings['facebook']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Instagram</label>
    <div class="col-sm-10">
      <input type="text" name="instagram" id="instagram" placeholder="Enter Instagram link" class="form-control" value="<?= htmlspecialchars($settings['instagram']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">X</label>
    <div class="col-sm-10">
      <input type="text" name="x" id="x" placeholder="Enter X/Twitter link" class="form-control" value="<?= htmlspecialchars($settings['x']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Linkedin</label>
    <div class="col-sm-10">
      <input type="text" name="linkedin" id="linkedin" placeholder="Enter Linkedin link/handle" class="form-control" value="<?= htmlspecialchars($settings['linkedin']) ?>">
    </div>
  </div>
  
  <div class="row mb-3">
    <label class="col-sm-2 col-form-label">Youtube</label>
    <div class="col-sm-10">
      <input type="text" name="youtube" id="youtube" placeholder="Enter Youtube link/handle" class="form-control" value="<?= htmlspecialchars($settings['youtube']) ?>">
    </div>
  </div>

  


  <div class="row mb-3">
    <div class="col-sm-10 offset-sm-2">
      <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
      <button type="submit" class="btn btn-primary">Update Settings</button>
    </div>
  </div>

</form>

<div id="msg"></div>

          </div>
        </div>

      </div>
    </div>
  </section>

  </main><!-- End #main -->

     <?php include("templates/footer.php"); ?>
  

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/settings.js"></script>

</body>

</html>