<?php include_once('./config.php'); ?>
<?php
function getImagePath($path) {
    if (strpos($path, '../') === 0) {
        $path = substr($path, 3);
    }
    return $path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Online Payment | <?= htmlspecialchars($settings['site_name']) ?></title>
<link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">
  <!--====== Bootstrap css ======-->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />

  <!--====== Line Icons css ======-->
  <link rel="stylesheet" href="assets/css/lineicons.css" />

  <link rel="stylesheet" href="style.css" />

  <style>
    body {
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      background-color: #f8f9fa;
    }

    main {
      flex: 1;
      padding: 0px 0px;
    }

.payment-header {
  background-color: #fff;
  border-bottom: 2px solid #e3f2fd; /* light blue line */
  padding: 20px 0 15px; /* thin but balanced */
  position: relative;
  z-index: 5;
}

.payment-header-content {
  max-width: 500px;
  margin: 0 auto;
}

.payment-header .logo {
  max-height: 55px;
  width: auto;
}

.payment-header .title {
  color: #007bff;
  font-weight: 700;
  font-size: 1.6rem;
  margin-bottom: 3px;
}

.payment-header .subtitle {
  font-size: 0.9rem;
  color: #6c757d;
  letter-spacing: 0.3px;
}

.payment-header::after {
  content: "";
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 3px;
  background: linear-gradient(to right, #007bff, #00b4d8);
  opacity: 0.1;
}

@media (max-width: 576px) {
  .payment-header {
    padding: 15px 0;
  }
  .payment-header .logo {
    max-height: 45px;
  }
  .payment-header .title {
    font-size: 1.3rem;
  }
}

    footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 20px 0;
      text-align: center;
      color: #555;
    }

    footer a {
      color: #007bff;
      text-decoration: none;
    }

    footer a:hover {
      text-decoration: underline;
    }
.card {
  border-radius: 10px;
}

.form-label {
  color: #333;
}

.btn-primary {
  background-color: #007bff;
  border-color: #007bff;
  font-weight: 500;
  transition: 0.3s;
}

.btn-primary:hover {
  background-color: #0056d6;
  border-color: #0056d6;
}
/* Compact design */
#verifyCard {
  max-width: 380px;
  margin: 0 auto;
}

#verifyForm .form-control, 
#verifyForm .form-select {
  font-size: 0.85rem;
  padding: 4px 6px;
}

#verifyForm label {
  font-size: 0.85rem;
}

.btn-sm {
  font-size: 0.85rem;
  padding: 3px 10px;
}

/* Smooth fade-in animation for result column */
#resultCol {
  animation: fadeIn 0.3s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform:translateY(10px);}
  to {opacity:1; transform:translateY(0);}
}
#qrSection img {
  width: 160px;   /* smaller QR */
  height: 160px;
  background: #fff;
  padding: 6px;
  border-radius: 6px;
}

  </style>
</head>
<body>

  <!-- Header -->
<header class="payment-header text-center shadow-sm">
  <div class="container">
    <div class="payment-header-content d-flex flex-column align-items-center">
      <a href="index.php" class="logo-link mb-2">
        <img src="<?= getImagePath($settings['logo']) ?>" alt="<?= htmlspecialchars($settings['site_name']) ?> Logo" class="logo">
      </a>
      <div class="header-text text-center">
        <h3 class="title mb-1">Pay Online</h3>
        <p class="subtitle mb-0">Fast • Secure • Convenient</p>
      </div>
    </div>
  </div>
</header>

<!-- Main Content -->
<main>
  <div class="container py-5 d-flex justify-content-center align-items-start" style="min-height: 70vh;">
    <div class="row w-100 justify-content-center" id="contentRow" style="max-width: 1000px;">
      <!-- Verification Column -->
      <div class="col-md-5 mb-4" id="verifyCol">
        <div class="card border-0 shadow-sm" id="verifyCard">
          <div class="card-body p-3">
            <h6 class="mb-3 text-primary text-center fw-semibold">Verify Your Enrollment</h6>

            <form id="verifyForm" class="small">
              <!-- Select Batch -->
              <div class="mb-2">
                <label for="batch_id" class="form-label fw-semibold small mb-1">Select Batch</label>
                <select name="batch_id" id="batch_id" class="form-select form-select-sm" required>
                  <option value="">-- Select Batch --</option>
                  <?php
                    $batchQuery = $conn->query("SELECT * FROM batch WHERE status='Active' AND deleted_at is NULL");
                    while ($b = $batchQuery->fetch_assoc()) {
                        $course = $conn->query("SELECT name FROM course WHERE id='".$b['cid']."'")->fetch_assoc();
                        echo '<option value="'.$b['id'].'">'.htmlspecialchars($course['name']).' - '.htmlspecialchars($b['title']).'</option>';
                    }
                  ?>
                </select>
              </div>

              <!-- Reg No or Mobile -->
              <div class="mb-2">
                <label for="reg_mobile" class="form-label fw-semibold small mb-1">Registration No. or Mobile</label>
                <input type="text" name="reg_mobile" id="reg_mobile" class="form-control form-control-sm" placeholder="Enter registration or mobile" required>
              </div>

              <!-- Submit Button -->
              <div class="text-center mt-3">
                <button type="submit" class="btn btn-primary btn-sm px-3">Verify</button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Result Column (hidden initially) -->
      <div class="col-md-7" id="resultCol" style="display:none;">
        <div id="verificationResult" class="card border-0 shadow-sm p-3 small" style="max-height: 120vh; overflow-y:auto;"></div>
      </div>
    </div>
  </div>
</main>


  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
      <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>
  <style>
      #qrSection img {
  background: #fff;
  padding: 10px;
}

  </style>
<script>
const settings = {
  upi_id: "<?= htmlspecialchars($settings['upi_id'] ?? '', ENT_QUOTES) ?>",
  site_name: "<?= htmlspecialchars($settings['site_name'] ?? 'Smart Institute', ENT_QUOTES) ?>"
};

document.getElementById('verifyForm').addEventListener('submit', function(e) {
  e.preventDefault();

  const batch_id = document.getElementById('batch_id').value.trim();
  const reg_mobile = document.getElementById('reg_mobile').value.trim();
  const resultDiv = document.getElementById('verificationResult');

  if (!batch_id || !reg_mobile) {
    resultDiv.innerHTML = '<div class="alert alert-warning">Please select a batch and enter your registration number or mobile.</div>';
    return;
  }

  resultDiv.innerHTML = '<div class="text-center text-muted">Checking enrollment details...</div>';

  fetch('verify-enrollment.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ batch_id, reg_mobile })
  })
  .then(res => res.json())
  .then(data => {
    if (data.status === 'success') {
        
     // Show result column if hidden
document.getElementById('resultCol').style.display = 'block';

// Align both columns side-by-side after verify
document.getElementById('contentRow').classList.add('justify-content-between');
document.getElementById('verifyCol').classList.remove('justify-content-center');

        
        
      let paymentsHTML = '';
      let alertClass = 'alert-secondary';

      if (data.fee_status.toLowerCase() === 'paid') alertClass = 'alert-success';
      else if (data.fee_status.toLowerCase() === 'partial') alertClass = 'alert-warning';
      else if (data.fee_status.toLowerCase() === 'pending') alertClass = 'alert-danger';

      // --- Payment History Table ---
      if (data.payments.length > 0) {
        paymentsHTML = `
          <h6 class="mt-4 mb-2">Payment History:</h6>
          <table class="table table-sm table-bordered">
            <thead class="table-light">
              <tr><th>Date</th><th>Mode</th><th>Amount</th><th>Status</th></tr>
            </thead>
            <tbody>
              ${data.payments.map(p => `
                <tr>
                  <td>${p.payment_date}</td>
                  <td>${p.payment_mode}</td>
                  <td>₹${p.payment_amount}</td>
                  <td>
  <span class="badge" style="
    background-color: ${
      p.payment_status.toLowerCase() === 'paid'
        ? '#28a745'       // Green
        : p.payment_status.toLowerCase() === 'failed'
        ? '#dc3545'       // Red
        : '#ffc107'       // Yellow (Pending or others)
    };
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 12px;
  ">
    ${p.payment_status}
  </span>
</td>

                </tr>`).join('')}
            </tbody>
          </table>`;
      } else {
        paymentsHTML = `<p class="text-muted">No previous payments found.</p>`;
      }

      // --- Determine whether to show payment form ---
      const remainingAmount = parseFloat(data.remaining || 0);
      const hasRemaining = remainingAmount > 0;
      const latestPayment = data.payments.length > 0 ? data.payments[data.payments.length - 1] : null;
      const latestStatus = latestPayment ? latestPayment.payment_status.toLowerCase() : '';
      const canMakePayment = hasRemaining && latestStatus !== 'pending';

      let extraSection = '';

      if (canMakePayment) {
  extraSection = `
    <div class="mt-4">
      <h6>Make a Payment</h6>

      <!-- Amount + QR Button in same row -->
      <div class="row g-2 align-items-end mb-3">
        <div class="col-7">
          <label class="form-label fw-semibold small mb-1">Payable Amount (₹)</label>
          <input type="number" id="payAmount" class="form-control form-control-sm" min="1" value="${remainingAmount}">
        </div>
        <div class="col-5 text-end">
          <button id="generateQR" class="btn btn-primary btn-sm w-100 mt-3">Generate QR</button>
        </div>
      </div>

      <div id="qrSection" class="text-center my-2"></div>

      <!-- Next payment date -->
      <div class="mb-2" id="nextDateContainer" style="display:none;">
        <label class="form-label fw-semibold small mb-1">Next Payment Date</label>
        <input type="date" id="next_payment_date" class="form-control form-control-sm">
      </div>

      <!-- Transaction + Submit -->
      <div class="row g-2 align-items-end" id="txnRow">
        <div class="col-md-8">
          <label class="form-label fw-semibold small mb-1">Txn / Ref. ID</label>
          <input type="text" id="txnId" class="form-control form-control-sm" placeholder="Optional">
        </div>
        <div class="col-md-4 text-end">
          <button id="submitPayment" class="btn btn-success btn-sm w-100 mt-3">Submit</button>
        </div>
      </div>
    </div>`;
} else if (latestStatus === 'pending') {
  extraSection = `
    <div class="alert alert-warning mt-4">
      Your last payment is <strong>pending approval</strong>. Please wait until it’s confirmed before making another payment.
    </div>`;
}


      // --- Render Final Output ---
      resultDiv.innerHTML = `
        <div class="alert ${alertClass}">
          <p><strong>Student:</strong> ${data.student_name}</p>
          <p><strong>Course:</strong> ${data.course_name}</p>
          <p><strong>Batch:</strong> ${data.batch_title}</p>
          <p><strong>Total Fees:</strong> ₹${data.course_fees}</p>
          <p><strong>Fee Status:</strong> ${data.fee_status}</p>
          <p><strong>Remaining Balance:</strong> ₹${data.remaining}</p>
          ${paymentsHTML}
          ${extraSection}
        </div>
      `;

      resultDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });

      // --- Show Next Payment Date when partial payment entered ---
      const payAmountInput = document.getElementById('payAmount');
      const nextDateContainer = document.getElementById('nextDateContainer');
      if (payAmountInput) {
        payAmountInput.addEventListener('input', function() {
          const entered = parseFloat(this.value || 0);
          if (entered > 0 && entered < remainingAmount) {
            nextDateContainer.style.display = 'block';
          } else {
            nextDateContainer.style.display = 'none';
          }
        });
      }
      
      const txnRow = document.getElementById('txnRow');
if (payAmountInput) {
  payAmountInput.addEventListener('input', function() {
    const entered = parseFloat(this.value || 0);
    const nextContainer = document.getElementById('nextDateContainer');
    if (entered > 0 && entered < remainingAmount) {
      nextContainer.style.display = 'block';
      txnRow.classList.remove('align-items-end');
      txnRow.classList.add('mt-2');
    } else {
      nextContainer.style.display = 'none';
      txnRow.classList.add('align-items-end');
      txnRow.classList.remove('mt-2');
    }
  });
}


      // --- Generate QR ---
      const qrBtn = document.getElementById('generateQR');
      if (qrBtn) {
        qrBtn.addEventListener('click', function() {
          const amount = document.getElementById('payAmount').value.trim();
          if (!amount || amount <= 0) {
            alert('Please enter a valid amount.');
            return;
          }

          const upiId = settings.upi_id;
          const name = settings.site_name;
          if (!upiId) {
            alert('UPI ID not found.');
            return;
          }

          const upiUrl = `upi://pay?pa=${upiId}&pn=${encodeURIComponent(name)}&am=${encodeURIComponent(amount)}&cu=INR`;
          const qrImageUrl = `https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=${encodeURIComponent(upiUrl)}`;

          const qrSection = document.getElementById('qrSection');
          qrSection.innerHTML = `
            <p class="text-muted mb-2">Scan this QR using your UPI app to pay ₹${amount}</p>
            <img src="${qrImageUrl}" alt="UPI QR Code" class="border rounded shadow-sm">
            <p class="small mt-2 text-muted">UPI ID: ${upiId}</p>
          `;

          qrSection.scrollIntoView({ behavior: 'smooth', block: 'center' });
        });
      }

      // --- Submit Payment ---
      const submitBtn = document.getElementById('submitPayment');
      if (submitBtn) {
        submitBtn.addEventListener('click', async function() {
          const amount = parseFloat(document.getElementById('payAmount').value.trim());
          const txnId = document.getElementById('txnId').value.trim();
          const nextPaymentInput = document.getElementById('next_payment_date');
          let next_payment_date = '';

          if (!amount || amount <= 0) {
            alert('Please enter the amount you paid.');
            return;
          }

          if (amount < remainingAmount) {
            if (!nextPaymentInput.value) {
              alert('Please select the Next Payment Date for remaining balance.');
              nextPaymentInput.focus();
              return;
            }
            next_payment_date = nextPaymentInput.value;
          }

          const payload = {
            enrolment_id: data.enrolment_id,
            cid: data.course_id,
            bid: data.batch_id,
            mobile: data.student_mobile,
            payment_amount: amount,
            payment_mode: 'QR Code Payment',
            payment_source: 'Online',
            reference: txnId || '',
            next_payment_date: next_payment_date
          };

          try {
            const res = await fetch('submit-payment.php', {
              method: 'POST',
              headers: { 'Content-Type': 'application/json' },
              body: JSON.stringify(payload)
            });
            const result = await res.json();

            if (result.status === 'success') {
              alert('Payment record submitted successfully!');
              location.reload();
            } else {
              alert(result.message || 'Failed to save payment.');
            }
          } catch (err) {
            console.error(err);
            alert('An error occurred while submitting payment.');
          }
        });
      }

    } else {
      resultDiv.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
    }
  })
  .catch(err => {
    console.error(err);
    resultDiv.innerHTML = `<div class="alert alert-danger">An error occurred while verifying. Please try again.</div>`;
  });
});
</script>




</body>
</html>
<?php $conn->close(); ?>
