<?php
include_once('./config.php');
if (session_status() === PHP_SESSION_NONE) session_start();

// Redirect if not logged in
if (!isset($_SESSION['subscriber_id'])) {
  header("Location: login.php");
  exit;
}

// CSRF Token
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf = $_SESSION['csrf_token'];

// Get user details
$id = intval($_SESSION['subscriber_id']);
$stmt = $conn->prepare("SELECT name, email, mobile_no FROM subscriber WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Handle update info
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_info'])) {
    if (hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $name = trim($_POST['name']);
        $email = trim($_POST['email']);
        $stmt = $conn->prepare("UPDATE subscriber SET name = ?, email = ?, updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("ssi", $name, $email, $id);
        $stmt->execute();
        $_SESSION['flash'] = "Profile updated successfully.";
        header("Location: profile.php");
        exit;
    }

}
// Handle password change
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    if (hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $current = $_POST['current_password'];
        $new = $_POST['new_password'];
        $confirm = $_POST['confirm_password'];

        $stmt = $conn->prepare("SELECT password FROM subscriber WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $row = $stmt->get_result()->fetch_assoc();

        if (!password_verify($current, $row['password'])) {
            $error = "Current password is incorrect.";
        } elseif ($new !== $confirm) {
            $error = "New passwords do not match.";
        } else {
            $hash = password_hash($new, PASSWORD_BCRYPT);
            $stmt = $conn->prepare("UPDATE subscriber SET password = ?, updated_at = NOW() WHERE id = ?");
            $stmt->bind_param("si", $hash, $id);
            $stmt->execute();
            $_SESSION['flash'] = "Password changed successfully.";
            header("Location: profile.php");
            exit;
        }
    }
}

function getImagePath($path) {
  if (strpos($path, '../') === 0) {
    $path = substr($path, 3);
  }
  return $path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Profile | <?= htmlspecialchars($settings['site_name']) ?></title>
  <link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="style.css" />
  <style>
    main { padding: 40px 0; }
    .profile-card { max-width: 600px; margin: auto; }
    .form-label { font-weight: 500; }
    .unclickable { background-color: #e9ecef; cursor: not-allowed; }
    
    .payment-header {
  background-color: #fff;
  border-bottom: 2px solid #e3f2fd; /* light blue line */
  padding: 20px 0 15px; /* thin but balanced */
  position: sticky;
  top:0;
  z-index: 5;
}

.payment-header-content {
  max-width: 500px;
  margin: 0 auto;
}

.payment-header .logo {
  max-height: 55px;
  width: auto;
}

.payment-header .title {
  color: #007bff;
  font-weight: 700;
  font-size: 1.6rem;
  margin-bottom: 3px;
}

.payment-header .subtitle {
  font-size: 0.9rem;
  color: #6c757d;
  letter-spacing: 0.3px;
}

.payment-header::after {
  content: "";
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 3px;
  background: linear-gradient(to right, #007bff, #00b4d8);
  opacity: 0.1;
}

@media (max-width: 576px) {
  .payment-header {
    padding: 15px 0;
  }
  .payment-header .logo {
    max-height: 45px;
  }
  .payment-header .title {
    font-size: 1.3rem;
  }
}

    footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 20px 0;
      text-align: center;
      color: #555;
    }

    footer a {
      color: #007bff;
      text-decoration: none;
    }

    footer a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<!-- Header -->
<header class=" payment-header shadow-sm " >
  <div class="container d-flex justify-content-between align-items-center">
    <!-- Left: Logo and Title -->
    <div class="d-flex align-items-center">
      <a href="index.php" class="logo-link me-3">
        <img src="<?= getImagePath($settings['logo']) ?>" alt="<?= htmlspecialchars($settings['site_name']) ?> Logo" class="logo">
      </a>
      
    </div>

   
 <!-- Right: Profile Dropdown -->
      <div class="dropdown">
        <button class="btn border-0 bg-transparent" id="profileMenu" data-bs-toggle="dropdown" aria-expanded="false">
          <i class="bi bi-person-circle fs-2"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="profileMenu">
          <li><a class="dropdown-item disabled"><?= htmlspecialchars($user['name']); ?></a><hr class="dropdown-divider"></li>
          <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
          <li><a class="dropdown-item" href="subscription.php"><i class="bi bi-credit-card me-2"></i>Subscription</a></li>
          <li><hr class="dropdown-divider"></li>
          <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
        </ul>
      </div>


  </div>
</header>
    <a href="student-corner.php" class="btn btn-light text-primary" style="padding:6px 15px;">
    ← Back
</a>
<main>


  <div class="container ">
    <div class="profile-card bg-white shadow rounded p-4  ">
      <h4 class="text-primary mb-3 text-center"><i class="bi bi-person-circle me-2"></i>Profile Information</h4>

      <?php if (!empty($_SESSION['flash'])): ?>
        <div class="alert alert-success"><?= $_SESSION['flash']; unset($_SESSION['flash']); ?></div>
      <?php endif; ?>
      <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= $error; ?></div>
      <?php endif; ?>

      <!-- Profile & Password Section -->
<div class="container mt-4">
  <div class="row g-4">
    
<!-- Edit Info Form -->
<div class="col-md-8 col-lg-6 mx-auto" id="editProfileCol">
  <h5 class="text-secondary mb-3">
    <i class="bi bi-person-lines-fill me-2"></i>Edit Profile
  </h5>

  <form method="POST" class="mb-3">
    <input type="hidden" name="csrf_token" value="<?= $csrf ?>">

    <div class="mb-3">
      <label class="form-label">Full Name</label>
      <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($user['name']); ?>" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Email</label>
      <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']); ?>" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Mobile Number</label>
      <input type="text" class="form-control unclickable" value="<?= htmlspecialchars($user['mobile_no']); ?>" readonly>
    </div>

    <button type="submit" name="update_info" class="btn btn-primary w-100">Update Profile</button>
  </form>

  <!-- Toggle link -->
  <div class="text-center">
    <a href="javascript:void(0)" id="showChangePassword" class="text-decoration-none text-primary fw-semibold">
      <i class="bi bi-shield-lock me-1"></i>Change Password
    </a>
  </div>
</div>

<!-- Change Password Form (Hidden by default) -->
<div class="col-md-8 col-lg-6 mx-auto mt-4 d-none" id="changePasswordCol">
  <h5 class="text-secondary mb-3">
    <i class="bi bi-shield-lock me-2"></i>Change Password
  </h5>

  <form method="POST">
    <input type="hidden" name="csrf_token" value="<?= $csrf ?>">

    <div class="mb-3">
      <label class="form-label">Current Password</label>
      <input type="password" name="current_password" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">New Password</label>
      <input type="password" name="new_password" class="form-control" minlength="6" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Confirm New Password</label>
      <input type="password" name="confirm_password" class="form-control" minlength="6" required>
    </div>

    <button type="submit" name="change_password" class="btn btn-warning w-100">Change Password</button>
  </form>
</div>


  </div>
</div>

    </div>
  </div>
</main>

  <!-- Footer -->
  <footer>
    <p>┬й <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
      <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>

<script>
  // Toggle Change Password visibility
  document.getElementById('showChangePassword').addEventListener('click', () => {
    const section = document.getElementById('changePasswordCol');
    section.classList.toggle('d-none');
    document.getElementById('showChangePassword').textContent = 
      section.classList.contains('d-none') ? 'Change Password' : 'Hide Password Section';
  });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php $conn->close(); ?>
