<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

require './office-login/PHPMailer/PHPMailer.php';
require './office-login/PHPMailer/SMTP.php';
require './office-login/PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// JSON or redirect - we'll redirect with flash
function bad($msg){
    $_SESSION['flash'] = $msg;
    header("Location: register.php");
    exit;
}

// -----------------------------------------
// SEND WELCOME MAIL
// -----------------------------------------
function sendWelcomeMail($to, $name) {
    global $conn;

    // fetch SMTP settings
    $set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM settings LIMIT 1"));

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host     = $set['smtp_host'];
        $mail->SMTPAuth = true;

        // fallback for Brevo ENV credentials
        if (
            strtolower(trim($set['smtp_host'])) === 'smtp-relay.brevo.com' &&
            (empty(trim($set['username'])) || empty(trim($set['password'])))
        ) {
            $mail->Username = getenv('SMTP_USER');
            $mail->Password = getenv('SMTP_PASS');
        } else {
            $mail->Username = $set['username'];
            $mail->Password = $set['password'];
        }

        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $set['port_number'];

        // sender details
        $mail->setFrom($set['sender_email'], $set['display_name_email']);
        $mail->addAddress($to);

        // construct subscribe button
        $subscribeUrl = $set['base_url'] . "subscription.php";
        $institute=$set['site_name'];
        // email body
        $mail->isHTML(true);
        $mail->Subject = "Welcome to Smart Institute! 🎉";

        $mail->Body = "
            <h2>Hello <strong>$name</strong> 👋</h2>

            <p>Thank you for registering with <strong>$institute</strong>! Student Corner.</p>

            <p>Subscribe to unlock full premium access to:</p>

            <ul>
                <li>📘 Free Study Materials</li>
                <li>📝 Notes</li>
                <li>🎥 Live Classes</li>
                <li>❓ Quizzes</li>
                <li>⭐ Other Premium Educational Services</li>
            </ul>

            

            <p>
                <a href='$subscribeUrl'
                   style='display:inline-block;padding:12px 20px;
                          background:#007bff;color:#fff;
                          border-radius:5px;text-decoration:none;
                          font-size:16px;font-weight:bold;'>
                    Subscribe Now
                </a>
            </p>

            <br>
            <p>Regards,<br><strong>$institute</strong></p>
        ";

        return $mail->send();

    } catch (Exception $e) {
        // OPTIONAL: Log actual SMTP error
        error_log("Registration Mail Error: " . $mail->ErrorInfo);
        return false;
    }
}

// -----------------------------------------
// FORM VALIDATION
// -----------------------------------------
if ($_SERVER['REQUEST_METHOD'] !== 'POST') bad('Invalid request method');

if (empty($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token']))
    bad('CSRF validation failed');

$name   = trim($_POST['name'] ?? '');
$email  = trim($_POST['email'] ?? '');
$mobile = trim($_POST['mobile_no'] ?? '');
$pwd    = $_POST['password'] ?? '';

if (!$name || !$email || !$pwd) bad('Name, email and password are required');
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) bad('Invalid email');
if (strlen($pwd) < 8) bad('Password must be at least 8 characters');

// duplicate check
$stmt = $conn->prepare("SELECT id FROM subscriber WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows > 0)
    bad('Email already registered. Please login or use forgot password.');
    
$stmt = $conn->prepare("SELECT id FROM subscriber WHERE mobile_no = ? LIMIT 1");
$stmt->bind_param("s", $mobile);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows > 0)
    bad('Mobile already registered. Please login or use forgot password.');

// insert user
$hash = password_hash($pwd, PASSWORD_DEFAULT);

$stmt = $conn->prepare("INSERT INTO subscriber (name, email, mobile_no, password) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $name, $email, $mobile, $hash);

if ($stmt->execute()) {

    // SEND WELCOME EMAIL
    sendWelcomeMail($email, $name);

    $_SESSION['flash'] = 'Registration successful';
    header("Location: login.php");
    exit;

} else {
    bad('Registration failed. Try again later.');
}

