<?php
include_once('./config.php');
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf = $_SESSION['csrf_token'];



function getImagePath($path) {
  if (strpos($path, '../') === 0) {
      $path = substr($path, 3);
  }
  return $path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Reset Password | <?= htmlspecialchars($settings['site_name']) ?></title>
  <link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body { background-color: #f8f9fa; display: flex; flex-direction: column; min-height: 100vh; }
    main { flex: 1; }

    .payment-header { background-color: #fff; border-bottom: 2px solid #e3f2fd; padding: 20px 0; position: relative; }
    .payment-header .logo { max-height: 55px; }
    .payment-header .title { color: #007bff; font-weight: 700; font-size: 1.6rem; }

    footer { background-color: #fff; border-top: 1px solid #ddd; padding: 20px 0; text-align: center; color: #555; }
    footer a { color: #007bff; text-decoration: none; }

  </style>
</head>

<body>
  <!-- Header -->
  <header class="payment-header text-center shadow-sm">
    <div class="container">
      <a href="index.php"><img src="<?= getImagePath($settings['logo']) ?>" alt="Logo" class="logo"></a>
      
    </div>
  </header>

  <!-- Main Content -->
  <main>
    <div class="container py-5">
 <?php
// Get subscriber ID & token
$uid = $_GET['id'] ?? '';
$token = $_GET['token'] ?? '';
$valid = false;
$error_msg = "";

// Only validate if parameters exist
if ($uid && $token) {

    // Fetch reset token details
    $stmt = $conn->prepare("
        SELECT token, expires_at 
        FROM password_resets 
        WHERE subscriber_id = ? 
        LIMIT 1
    ");
    $stmt->bind_param("i", $uid);
    $stmt->execute();
    $tokenRow = $stmt->get_result()->fetch_assoc();

    if ($tokenRow) {
        if (password_verify($token, $tokenRow['token'])) {
            if (strtotime($tokenRow['expires_at']) > time()) {
                $valid = true; // Token OK ✔️
            } else {
                $error_msg = "This reset link has expired. Please request a new one.";
            }
        } else {
            $error_msg = "Invalid reset token.";
        }
    } else {
        $error_msg = "Invalid or expired reset link.";
    }
} else {
    $error_msg = "Missing reset parameters.";
}
?>

<div class="row justify-content-center">
  <div class="col-md-6">

    <?php if (!$valid): ?>
      <!-- ❌ INVALID / EXPIRED TOKEN MESSAGE -->
      <div class="alert alert-danger shadow-sm p-4 text-center">
        <h5 class="fw-bold">Reset Link Error</h5>
        <p><?= htmlspecialchars($error_msg) ?></p>
        <a href="forgot.php" class="btn btn-primary btn-sm mt-3">
          Request New Reset Link
        </a>
      </div>

    <?php else: ?>
      <!-- ✔️ PASSWORD RESET FORM -->
      <div class="card shadow-sm border-0">
        <div class="card-body p-4">

          <h4 class="mb-3 text-center fw-bold">
            <i class="bi bi-key-fill text-warning"></i> Reset Your Password
          </h4>

          <form method="post" action="reset_action.php" id="resetForm">

            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="subscriber_id" value="<?= intval($uid) ?>">
            <input type="hidden" name="raw_token" value="<?= htmlspecialchars($_GET['token']) ?>">


            <div class="mb-3">
              <label class="form-label fw-semibold">New Password</label>
              <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-lock"></i></span>
                <input type="password" name="password" required minlength="8"
                       class="form-control rounded-end"
                       placeholder="Minimum 8 characters">
              </div>
              <small class="text-muted">Password must be at least 8 characters long.</small>
            </div>

            <div class="mb-3">
              <label class="form-label fw-semibold">Confirm New Password</label>
              <div class="input-group">
                <span class="input-group-text bg-light"><i class="bi bi-lock-fill"></i></span>
                <input type="password" name="confirm_password" required minlength="8"
                       class="form-control rounded-end"
                       placeholder="Retype your password">
              </div>
            </div>

            <div class="d-grid">
              <button type="submit" class="btn btn-warning fw-semibold py-2">
                <i class="bi bi-check-circle me-1"></i> Update Password
              </button>
            </div>

          </form>

        </div>
      </div>
    <?php endif; ?>

  </div>
</div>

    </div>
  </main>
  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> |
      Designed by <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>
  <script>
document.getElementById("resetForm").addEventListener("submit", function(e) {
    const pass = document.querySelector("input[name='password']").value.trim();
    const confirmPass = document.querySelector("input[name='confirm_password']").value.trim();

    // Remove previous error message if exists
    let oldError = document.getElementById("passwordError");
    if (oldError) oldError.remove();

    // Validate matching passwords
    if (pass !== confirmPass) {
        e.preventDefault();

        let errorDiv = document.createElement("div");
        errorDiv.id = "passwordError";
        errorDiv.className = "alert alert-danger mt-3";
        errorDiv.innerHTML = "<strong>Error:</strong> Passwords do not match.";

        document.getElementById("resetForm").appendChild(errorDiv);
        return;
    }

    // Validate minimum length
    if (pass.length < 8) {
        e.preventDefault();

        let errorDiv = document.createElement("div");
        errorDiv.id = "passwordError";
        errorDiv.className = "alert alert-danger mt-3";
        errorDiv.innerHTML = "<strong>Error:</strong> Password must be at least 8 characters long.";

        document.getElementById("resetForm").appendChild(errorDiv);
        return;
    }

});
</script>

</body>
</html>
<?php $conn->close(); ?>