<?php
session_start();
include("config.php");
include("log_activity.php");

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    die("Invalid file request.");
}

// Fetch file info safely
$stmt = $conn->prepare("SELECT link, title, restriction FROM student_corner WHERE id=? AND status='Active' AND (deleted_at IS NULL OR deleted_at='')");
$stmt->bind_param("i", $id);
$stmt->execute();
$file = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$file) {
    die("File not found or inactive.");
}

// Check restriction + session
$loggedIn = isset($_SESSION['subscriber_id']);
$subscribed = ($loggedIn 
               && isset($_SESSION['subscriber_status']) 
               && $_SESSION['subscriber_status'] === 'subscribed');

if ($file['restriction'] === 'Restricted') {

    if (!$loggedIn) {
        header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }

    if (!$subscribed) {
        header("Location: subscription.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
}


// Prevent direct path traversal or external URL
$link = ltrim($file['link'], '/');
if (str_contains($link, '..')) {
    die("Unauthorized access.");
}

// Build full path
$filepath = __DIR__ . "/office-login/" . $link;

// Verify file exists and is readable
if (!is_file($filepath) || !file_exists($filepath)) {
    die("Requested file is missing or inaccessible.");
}

// ✅ ✅ LOG ACTIVITY — only when logged in
if ($loggedIn) {
    logActivity($conn, $_SESSION['subscriber_id'], "Downloaded: " . $file['title']);
}

// Force download
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filepath));
flush();
readfile($filepath);
exit;
?>

