<?php include_once('./config.php');

if (session_status() === PHP_SESSION_NONE) session_start();

// Fetch Student Corner ads
$settingsQuery = "SELECT * FROM settings LIMIT 1";
$settingsResult = mysqli_query($conn, $settingsQuery);
$settings = mysqli_fetch_assoc($settingsResult);

// Fetch subscriber name
$id = intval($_SESSION['subscriber_id']);
$stmt = $conn->prepare("SELECT name FROM subscriber WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
?>
<?php
function getImagePath($path) {
    if (strpos($path, '../') === 0) {
        $path = substr($path, 3);
    }
    return $path;
}
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Student Corner | <?= htmlspecialchars($settings['site_name']) ?></title>
<link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">

<!-- Bootstrap 5 CSS -->
<link
  href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
  rel="stylesheet"
  integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
  crossorigin="anonymous">
 

<!-- Bootstrap 5 JS (includes Popper) -->



<!-- Bootstrap Icons -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css"
    rel="stylesheet"
  />
<style>
    #chatbotButton {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background-color: #0d6efd;
      color: #fff;
      border: none;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      font-size: 28px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
      z-index: 1050;
      display: flex;
      justify-content: center;
      align-items: center;
      cursor: pointer;
      transition: transform 0.2s, background-color 0.3s;
    }
    #chatbotButton:hover {
      transform: scale(1.1);
      background-color: #0b5ed7;
    }

    #chatWindow {
      position: fixed;
      bottom: 90px;
      right: 20px;
      width: 350px;
      max-height: 500px;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
      display: none;
      flex-direction: column;
      overflow: hidden;
      z-index: 1100;
      opacity: 0;
      transform: translateY(20px);
      transition: all 0.3s ease;
    }
    #chatWindow.show {
      display: flex;
      opacity: 1;
      transform: translateY(0);
    }

    .chat-header {
      background-color: #0d6efd;
      color: white;
      padding: 10px 15px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-shrink: 0;
    }
    .chat-header button {
      background: transparent;
      border: none;
      color: white;
      font-size: 1.2rem;
      cursor: pointer;
    }

    .chat-body {
      flex: 1;
      padding: 10px;
      overflow-y: auto;
      font-size: 14px;
      background-color: #f8f9fa;
    }

    .chat-input {
      display: flex;
      border-top: 1px solid #ccc;
    }
    .chat-input input {
      border: none;
      flex: 1;
      padding: 10px;
      outline: none;
    }
    .chat-input button {
      background-color: #0d6efd;
      color: white;
      border: none;
      padding: 10px 15px;
    }

    .msg {
      margin-bottom: 10px;
    }
    .msg.user {
      text-align: right;
    }
    .msg.bot {
      text-align: left;
    }
    .msg span {
      display: inline-block;
      padding: 8px 12px;
      border-radius: 12px;
      max-width: 80%;
      word-wrap: break-word;
    }
    .msg.user span {
      background: #0d6efd;
      color: white;
    }
    .msg.bot span {
      background: #e9ecef;
    }
    
  </style>
  
  <!--====== Line Icons css ======-->
  <link rel="stylesheet" href="assets/css/lineicons.css" />

  <link rel="stylesheet" href="style.css" />

  <style>
    body {
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      background-color: #f8f9fa;
    }

    main {
      flex: 1;
      padding: 0px 0px;
    }

.payment-header {
  background-color: #fff;
  border-bottom: 2px solid #e3f2fd; /* light blue line */
  padding: 20px 0 15px; /* thin but balanced */
  position: sticky;
  top:0;
  z-index: 5;
}

.payment-header-content {
  max-width: 500px;
  margin: 0 auto;
}

.payment-header .logo {
  max-height: 55px;
  width: auto;
}

.payment-header .title {
  color: #007bff;
  font-weight: 700;
  font-size: 1.6rem;
  margin-bottom: 3px;
}

.payment-header .subtitle {
  font-size: 0.9rem;
  color: #6c757d;
  letter-spacing: 0.3px;
}

.payment-header::after {
  content: "";
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 3px;
  background: linear-gradient(to right, #007bff, #00b4d8);
  opacity: 0.1;
}

@media (max-width: 576px) {
  .payment-header {
    padding: 15px 0;
  }
  .payment-header .logo {
    max-height: 45px;
  }
  .payment-header .title {
    font-size: 1.3rem;
  }
}

    footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 20px 0;
      text-align: center;
      color: #555;
    }

    footer a {
      color: #007bff;
      text-decoration: none;
    }

    footer a:hover {
      text-decoration: underline;
    }
    
/* Tab Design */
/* Stylish Tabs */
.stylish-tabs {
  border: none;
  position: relative;
  background: #0d6efd; /* ✅ Always Blue */
  border-radius: 10px 10px 0 0;
  padding: 5px 5px;
  overflow-x: auto;
  white-space: nowrap;
}

/* Inactive tabs */
.stylish-tabs .nav-link {
  border: none;
  color: #ffffff; /* ✅ White text */
  font-weight: 500;
  padding: 12px 25px;
  background: transparent; /* ✅ Transparent over blue */
  transition: all 0.3s ease;
}

/* Hover effect */
.stylish-tabs .nav-link:hover {
  background: rgba(255, 255, 255, 0.15);
  color: #ffffff;
}

/* ✅ Active Tab (White) */
.stylish-tabs .nav-link.active {
  background: #ffffff !important; /* ✅ White */
  color: #0d6efd !important;      /* ✅ Blue text */
  border-radius: 30px;
  box-shadow: 0 3px 8px rgba(255, 255, 255, 0.3);
  transform: scale(1.05);
}


.stylish-tabs .nav-link i {
  font-size: 1rem;
}

/* Smooth Fade Animation for Tabs */
.tab-pane {
  animation: fadeInUp 0.4s ease;
}

@keyframes fadeInUp {
  from {
    opacity: 0;
    transform: translateY(15px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
/* Make nav horizontally scrollable but hidden scrollbar */
.stylish-tabs {
  display: flex;
  flex-wrap: nowrap;
  overflow-x: auto;
  overflow-y: hidden;
  scrollbar-width: none;
  -ms-overflow-style: none;
  white-space: nowrap;
}
.stylish-tabs::-webkit-scrollbar {
  display: none;
}
.stylish-tabs .nav-item {
  flex: 0 0 auto;
}

/* Keep search bar same size and aligned */
.search-input {
  width: 280px !important;
  max-width: 100%;
}

/* Prevent search input overflow inside card */
.tab-pane .d-flex {
  flex-wrap: wrap;
}

.ad-banner {
  max-width: 1000px;   /* ⬅ responsive width */
  width: 100%;         /* ⬅ allows shrinking on mobile */
  margin-left: auto;
  margin-right: auto;  /* ⬅ centers container */
}

.ad-banner img {
  width: 100%;          /* ⬅ make image fill container */
  height: 300px;        /* fixed height */
  object-fit: cover;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

  </style>
</head>
<body>




<!-- Header -->
<header class=" payment-header shadow-sm " >
  <div class="container d-flex justify-content-between align-items-center">
    <!-- Left: Logo and Title -->
    <div class="d-flex align-items-center">
      <a href="index.php" class="logo-link me-3">
        <img src="<?= getImagePath($settings['logo']) ?>" alt="<?= htmlspecialchars($settings['site_name']) ?> Logo" class="logo">
      </a>
      
    </div>

   
 <!-- Right: Profile Dropdown -->
      <div class="dropdown">
        <button class="btn border-0 bg-transparent" id="profileMenu" data-bs-toggle="dropdown" aria-expanded="false">
          <i class="bi bi-person-circle fs-2"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="profileMenu">
          <?php if (isset($_SESSION['subscriber_id'])): ?>
  <!-- ✅ Show name if logged in -->
  <li>
    <a class="dropdown-item disabled">
      <?= htmlspecialchars($user['name']); ?>
    </a>
    <hr class="dropdown-divider">
  </li>
<?php else: ?>
  
  <li>
    <a class="dropdown-item text-primary" href="login.php">
      <i class="bi bi-door-open"></i> Login
    </a>
    <hr class="dropdown-divider">
  </li>
<?php endif; ?>
          <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
          <li><a class="dropdown-item" href="subscription.php"><i class="bi bi-credit-card me-2"></i>Subscription</a></li>
          <?php if (isset($_SESSION['subscriber_id'])): ?>
          <li><hr class="dropdown-divider"></li>
          
          <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
          <?php endif; ?>
        </ul>
      </div>


  </div>
</header>

<?php if (!empty($settings['s_corner_header_ad'])): ?>
  <section class="ad-banner my-3 text-center">
    <img src="<?php echo htmlspecialchars($settings['s_corner_header_ad']); ?>" alt="Student Corner Header Ad" class="img-fluid rounded shadow-sm" style="max-width:100%; height:auto;">
  </section>
<?php endif; ?>

<div class="mt-2 d-flex justify-content-center">
    <a href="index.php" class="btn btn-light text-primary " style="padding:6px 15px;">
     <i class="bi bi-house"></i> Home
</a>
</div>

<!-- Main Content -->
<main>
  <div class="container py-5" style="margin-top:-25px">

    <!-- Tabs Navigation -->
   <ul class="nav nav-tabs justify-content-start stylish-tabs px-3" id="myTab" role="tablist">
        <?php
$tabs = [ 
    "notes" => ["Notes", "bi-journal-text", "Notes"],
    "assignments" => ["Assignments", "bi-pencil-square", "Assignments"],
    "study" => ["Study Materials", "bi-book-half", "Study Materials"], 
    "downloads" => ["Downloads", "bi-download", "Downloads"], 
    "videos" => ["Videos", "bi-play-circle", "Videos"], 
    "links" => ["Links", "bi-link-45deg", "Links"],

    // ✅ NEW TABS (Both are link type)
    "quiz" => ["Quiz", "bi-question-circle", "Quiz"],
    "live" => ["Live", "bi-broadcast", "Live"]
];
 
        
        $first = true; foreach ($tabs as $key => $tab) { [$label, $icon] = $tab;
        echo '<li class="nav-item" role="presentation">
        <button class="nav-link ' . ($first ? 'active' : '') . '" id="' . $key . '-tab" data-bs-toggle="tab" data-bs-target="#' . $key . '" type="button" role="tab"> <i class="bi ' . $icon . ' me-1"></i> ' . $label . ' </button> </li>'; $first = false; } ?> </ul>


<!-- Tabs Content -->
<div class="tab-content border border-top-0 bg-white rounded-bottom shadow-sm p-4" id="myTabContent">
  <?php
  $first = true;
  foreach ($tabs as $key => $tab) {
    [$label, $icon, $type] = $tab;
  ?>
    <div class="tab-pane fade <?= $first ? 'show active' : '' ?>" id="<?= $key ?>" role="tabpanel">

      <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
        <h5 class="fw-bold text-primary m-0">
          <i class="bi <?= $icon ?> me-2"></i><?= $label ?>
        </h5>
        <input type="text" 
               class="form-control search-input" 
               placeholder="Search <?= strtolower($label) ?>..." 
               onkeyup="filterData('<?= $key ?>', this.value)">
      </div>

      <div id="<?= $key ?>_content"></div>

      <div class="d-flex justify-content-center mt-3">
        <button class="btn btn-outline-primary btn-sm me-2" id="<?= $key ?>_prev" onclick="loadData('<?= $key ?>', currentPage['<?= $key ?>'] - 1)">Prev</button>
        <span class="fw-semibold small text-muted" id="<?= $key ?>_pageinfo"></span>
        <button class="btn btn-outline-primary btn-sm ms-2" id="<?= $key ?>_next" onclick="loadData('<?= $key ?>', currentPage['<?= $key ?>'] + 1)">Next</button>
      </div>
    </div>
  <?php
    $first = false;
  }
  ?>
</div>

  </div>

  <script>
    const currentPage = {};
    const searchTerm = {};

    document.addEventListener("DOMContentLoaded", () => {
      <?php
      foreach ($tabs as $key => $tab) {
        echo "currentPage['$key'] = 1; searchTerm['$key'] = ''; loadData('$key', 1);\n";
      }
      ?>
    });

    function loadData(tab, page = 1) {
      fetch(`fetch_student_corner.php?type=${tab}&page=${page}&search=${encodeURIComponent(searchTerm[tab] || '')}`)
        .then(res => res.text())
        .then(html => {
          document.getElementById(`${tab}_content`).innerHTML = html;
          currentPage[tab] = page;
          updatePagination(tab);
        })
        .catch(() => {
          document.getElementById(`${tab}_content`).innerHTML = "<div class='alert alert-danger'>Error loading data.</div>";
        });
    }

    function updatePagination(tab) {
      document.getElementById(`${tab}_pageinfo`).innerText = `Page ${currentPage[tab]}`;
    }

    function filterData(tab, term) {
      searchTerm[tab] = term;
      currentPage[tab] = 1;
      loadData(tab, 1);
    }
  </script>
</main>

<?php if($settings['chatbox']=="1") { ?>
   <button id="chatbotButton"><i class="bi bi-chat-dots-fill"></i></button>
   <?php } ?>

  <div id="chatWindow" class="d-flex flex-column">
    <div class="chat-header">
      <span>AI Assistant</span>
      <button id="closeChat" class="btn btn-sm btn-light"><i class="bi bi-x"></i></button>
    </div>
    <div class="chat-body" id="chatBody">
      <div class="msg bot"><span>ЁЯСЛ Hi! How can I help you today?</span></div>
    </div>
    <div class="chat-input">
      <input type="text" id="userInput" placeholder="Type your message..." />
      <button id="sendBtn"><i class="bi bi-send"></i></button>
    </div>
  </div>

  <script>
    const chatButton = document.getElementById("chatbotButton");
    const chatWindow = document.getElementById("chatWindow");
    const closeChat = document.getElementById("closeChat");
    const sendBtn = document.getElementById("sendBtn");
    const userInput = document.getElementById("userInput");
    const chatBody = document.getElementById("chatBody");

    chatButton.onclick = () => chatWindow.classList.toggle("show");
    closeChat.onclick = () => chatWindow.classList.remove("show");

    async function sendMessage() {  
      const message = userInput.value.trim();
      if (!message) return;
      appendMessage("user", message);
      userInput.value = "";
      appendMessage("bot", "тП│ Thinking...");

      try {
        const response = await fetch("chatbot.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ message })
        });

        const data = await response.json();
        removeThinking();
        appendMessage("bot", data.reply || "тЪая╕П No response from AI.");
      } catch (err) {
        removeThinking();
        appendMessage("bot", "тЪая╕П Server error. Please try again.");
      }
    }

    function appendMessage(sender, text) {
      const msgDiv = document.createElement("div");
      msgDiv.classList.add("msg", sender);
      msgDiv.innerHTML = `<span>${text}</span>`;
      chatBody.appendChild(msgDiv);
      chatBody.scrollTop = chatBody.scrollHeight;
    }    

    function removeThinking() {
      const lastMsg = chatBody.querySelector(".msg.bot span:last-child");
      if (lastMsg && lastMsg.textContent === "тП│ Thinking...") {
        lastMsg.parentElement.remove();
      }
    }

    sendBtn.onclick = sendMessage;
    userInput.addEventListener("keypress", (e) => {
      if (e.key === "Enter") sendMessage();
    });
  </script>

<?php if (!empty($settings['s_corner_footer_ad'])): ?>
  <section class="ad-banner my-3 text-center">
    <img src="<?php echo htmlspecialchars($settings['s_corner_footer_ad']); ?>" alt="Student Corner Footer Ad" class="img-fluid rounded shadow-sm" style="max-width:100%; height:auto;">
  </section>
<?php endif; ?>


  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
      <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>
  
  <script
  src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
  integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
  crossorigin="anonymous"></script>
</body>
</html>
<?php $conn->close(); ?>
