<?php
include_once('./config.php');
$data = json_decode(file_get_contents('php://input'), true);
ini_set('display_errors', 1);
error_reporting(E_ALL);

$ip = $_SERVER['REMOTE_ADDR'];

$bid = intval($data['batch_id']);
$student_mobile = $conn->real_escape_string($data['student_mobile']);
$device_id = trim(strtolower($conn->real_escape_string($data['device_id'] ?? '')));
$lat = floatval($data['lat'] ?? 0);
$lng = floatval($data['lng'] ?? 0);
$date = date('Y-m-d');
$status = 'Present';

// 🔹 Institute coordinates (from settings)
$institute_lat = floatval($settings['latitude'] ?? 0);
$institute_lng = floatval($settings['longitude'] ?? 0);

// Max allowed distance (in meters)
$allowed_radius = 200; // e.g., 200m range

if (!$bid || !$student_mobile || !$device_id) {
  echo json_encode(['status' => 'error', 'message' => 'Batch, student, and device ID required.']);
  exit;
}

// ✅ Check location proximity (Haversine formula)
function distanceMeters($lat1, $lon1, $lat2, $lon2) {
  $earthRadius = 6371000; // meters
  $dLat = deg2rad($lat2 - $lat1);
  $dLon = deg2rad($lon2 - $lon1);
  $a = sin($dLat/2) * sin($dLat/2) +
       cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
       sin($dLon/2) * sin($dLon/2);
  $c = 2 * atan2(sqrt($a), sqrt(1-$a));
  return $earthRadius * $c;
}

$distance = distanceMeters($lat, $lng, $institute_lat, $institute_lng);

if ($distance > $allowed_radius) {
  echo json_encode(['status' => 'error', 'message' => 'You are not within the allowed area to mark attendance.']);
  exit;
}

error_log("Checking device => bid=$bid | device_id=$device_id | date=$date");


// 🔒 Check if this device already marked attendance for this batch today
$check_device = $conn->query("
  SELECT id FROM attendance
  WHERE bid='$bid'
  AND LOWER(TRIM(device_id))='$device_id'
  AND DATE(date)='$date'
");

error_log("Device rows found: " . $check_device->num_rows);


if ($check_device->num_rows > 0) {
  echo json_encode(['status' => 'error', 'message' => 'Attendance already marked from this device for this batch today.']);
  exit;
}


// ✅ Check if this student already has attendance today for this batch
$check_student = $conn->query("SELECT id FROM attendance 
  WHERE bid='$bid' AND student_mobile='$student_mobile' AND DATE(date)='$date'");
if ($check_student->num_rows > 0) {
  echo json_encode(['status' => 'error', 'message' => 'Attendance already marked for this student today.']);
  exit;
}

// ✅ Insert attendance
$stmt = $conn->prepare("INSERT INTO attendance (bid, student_mobile, date, status, marked_by, device_id,ip_address) VALUES (?, ?, ?, ?, '', ?, ?)");
$stmt->bind_param('isssss', $bid, $student_mobile, $date, $status, $device_id, $ip);

if ($stmt->execute()) {
  echo json_encode(['status' => 'success', 'message' => 'Attendance marked successfully.']);
} else {
  echo json_encode(['status' => 'error', 'message' => 'Database error.']);
}
?>


