<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include_once('config.php');

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Decode JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Gracefully handle missing or invalid JSON
if (!$data || !is_array($data)) {
    echo json_encode(['success' => false, 'message' => 'Invalid input data.']);
    exit;
}

// Sanitize inputs safely
$name = htmlspecialchars(trim($data['name'] ?? ''), ENT_QUOTES);
$email = filter_var(trim($data['email'] ?? ''), FILTER_SANITIZE_EMAIL);
$phone = preg_replace('/[^0-9]/', '', $data['phone'] ?? '');
$subject = trim($data['subject'] ?? '');
$reference = trim($data['reference'] ?? '');
$message = htmlspecialchars(trim($data['message'] ?? ''), ENT_QUOTES);
$source = htmlspecialchars(trim($data['source'] ?? ''), ENT_QUOTES);
$course = trim($data['course_id'] ?? '');
$description = htmlspecialchars(trim($data['subject_description'] ?? ''), ENT_QUOTES);

// Validate essential fields
if (empty($name) || empty($email) || empty($phone) || empty($subject) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'All required fields must be filled.']);
    exit;
}

// Email and phone validation
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email format.']);
    exit;
}

if (!preg_match("/^[0-9]{10}$/", $phone)) {
    echo json_encode(['success' => false, 'message' => 'Phone number must be 10 digits.']);
    exit;
}

// Prepared Statement for Secure Insert
$sql = "INSERT INTO enquiries 
        (name, email, phone, subject, reference, message, source, course, subject_description)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    echo json_encode(['success' => false, 'message' => 'Database prepare failed: ' . $conn->error]);
    exit;
}

$stmt->bind_param("sssssssss", $name, $email, $phone, $subject, $reference, $message, $source, $course, $description);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Enquiry submitted successfully.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Database insertion failed: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>

