<?php
include_once('./config.php');
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

// Basic validation
if (!$data) {
  echo json_encode(['status'=>'error','message'=>'Invalid data received']);
  exit;
}

$batch_id = $conn->real_escape_string($data['batch_id']);
$student_mobile = $conn->real_escape_string($data['student_mobile'] ?? '');
$name = $conn->real_escape_string($data['name'] ?? '');
$mobile = $conn->real_escape_string($data['mobile'] ?? '');
$course_rating = intval($data['course_content'] ?? 0);
$teacher_rating = intval($data['trainer_teaching'] ?? 0);
$environment_rating = intval($data['environment'] ?? 0);
$message = $conn->real_escape_string($data['message'] ?? '');
$created_at = date('Y-m-d H:i:s');

// Required fields
if (!$batch_id) {
  echo json_encode(['status'=>'error','message'=>'Batch is required']);
  exit;
}
if ($course_rating == 0 || $teacher_rating == 0 || $environment_rating == 0) {
  echo json_encode(['status'=>'error','message'=>'All ratings are required']);
  exit;
}

if ($batch_id === 'other') {
  if (!$name || !$mobile) {
    echo json_encode(['status'=>'error','message'=>'Name and mobile are required']);
    exit;
  }
  $student = $name . ', ' . $mobile;
} else {
  if (!$student_mobile) {
    echo json_encode(['status'=>'error','message'=>'Student selection is required']);
    exit;
  }

  // Fetch student name from database
  $res = $conn->query("SELECT name FROM student WHERE mobile='$student_mobile' LIMIT 1");
  if ($res && $res->num_rows > 0) {
    $student_row = $res->fetch_assoc();
    $student = $student_row['name'] . ' (' . $student_mobile . ')';
  } else {
    $student = $student_mobile;
  }
}

// Insert feedback
$sql = "INSERT INTO feedback 
        (batch, student, course_rating, teacher_rating, environment_rating, message) 
        VALUES 
        ('$batch_id', '$student', '$course_rating', '$teacher_rating', '$environment_rating', '$message')";

if ($conn->query($sql)) {
  echo json_encode(['status'=>'success','message'=>'Thank you! Your feedback has been submitted successfully.']);
} else {
  echo json_encode(['status'=>'error','message'=>'Database error: '.$conn->error]);
}

$conn->close();
?>
