<?php
include './config.php'; // adjust path as needed
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data']);
    exit;
}

$enrolment_id = $data['enrolment_id'] ?? '';
$cid = $data['cid'] ?? '';
$bid = $data['bid'] ?? '';
$mobile = $data['mobile'] ?? '';
$payment_amount = $data['payment_amount'] ?? 0;
$payment_mode = $data['payment_mode'] ?? 'QR Code Payment';
$payment_source = 'Outside';
$reference = $data['reference'] ?? '';
$next_payment_date = $data['next_payment_date'] ?? null;
$payment_date = date('Y-m-d');
$payment_status = 'Pending';

error_log(print_r($data, true)); // Logs what came from JS


if (!$enrolment_id || !$cid || !$bid || !$mobile || !$payment_amount) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
    exit;
}

$stmt = $conn->prepare("INSERT INTO fees_receipts 
(enrolment_id, cid, bid, mobile, payment_date, next_payment_date, payment_mode, payment_source, reference, payment_amount, payment_status)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("iiissssssds",
  $enrolment_id,
  $cid,
  $bid,
  $mobile,
  $payment_date,
  $next_payment_date,
  $payment_mode,
  $payment_source,
  $reference,
  $payment_amount,
  $payment_status
);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => $stmt->error]);
}

$stmt->close();
$conn->close();
?>

