<?php
include_once('./config.php');
if (session_status() === PHP_SESSION_NONE) session_start();

// Redirect if not logged in
if (!isset($_SESSION['subscriber_id'])) {
  header("Location: login.php");
  exit;
}

// Fetch subscriber details (status & mobile)
$id = intval($_SESSION['subscriber_id']);
$stmt = $conn->prepare("SELECT name, mobile_no, status FROM subscriber WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Fetch current subscription by mobile_no
$stmt = $conn->prepare("SELECT * FROM subscriptions WHERE mobile_no = ? AND deleted_at IS NULL ORDER BY id DESC LIMIT 1");
$stmt->bind_param('s', $user['mobile_no']);
$stmt->execute();
$userSub = $stmt->get_result()->fetch_assoc();



function getImagePath($path) {
  if (strpos($path, '../') === 0) $path = substr($path, 3);
  return $path;
}

// âœ… Dynamic plan from settings
$plan = [
  'type' => 'Subscription Plan',
  'amount' => floatval($settings['subscription_amount']),
  'duration' => htmlspecialchars($settings['subscription_validity']),
  'features_html' => $settings['subscription_details'] // contains HTML (list, headings etc.)
];

// Default header (for safety)
$headerClass = 'bg-light text-dark';
$headerText  = 'Not Subscribed';

// If user.status = subscribed
if ($user['status'] === 'subscribed') {

  // Get expiry from subscriptions table if exists
  if ($userSub) {
    $today = new DateTime();
    $expiry = new DateTime($userSub['sub_expiry']);
    $daysLeft = $today->diff($expiry)->days;

    if ($expiry < $today) {
      $headerClass = 'bg-secondary text-white';
      $headerText = 'Subscription Expired';
    } elseif ($daysLeft <= 7) {
      $headerClass = 'bg-warning text-dark';
      $headerText = "Expiring Soon &ndash; $daysLeft day(s) left";
    } else {
      $headerClass = 'bg-success text-white';
      $headerText = 'Active Subscription';
    }
  } else {
    // Subscribed in table but no record in subscriptions
    $headerClass = 'bg-success text-white';
    $headerText = 'Subscribed';
  }

} else {
  // If user.status = unsubscribed or something else
  $headerClass = 'bg-light text-dark';
  $headerText = 'Not Subscribed';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscription | <?= htmlspecialchars($settings['site_name']) ?></title>
<link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    .plan-card { border-radius: 15px; overflow: hidden; transition: transform .3s; border: 1px solid #e0e0e0; }
    .plan-card:hover { transform: translateY(-5px); box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
    .card-header { font-weight: 600; font-size: 1.1rem; }
    .countdown { font-weight: 600; color: #d9534f; }

    .payment-header {
      background-color: #fff;
      border-bottom: 2px solid #e3f2fd;
      padding: 20px 0;
      position: sticky;
      top: 0;
      z-index: 5;
    }
    .payment-header .logo { max-height: 55px; width: auto; }

    footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      margin-top:50px;
      
      text-align: center;
      color: #555;
     
    }
    footer a { color: #007bff; text-decoration: none; }
    footer a:hover { text-decoration: underline; }
  </style>
  <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
</head>
<body>

<!-- Header -->
<header class="payment-header shadow-sm">
  <div class="container d-flex justify-content-between align-items-center">
    <div class="d-flex align-items-center">
      <a href="index.php" class="logo-link me-3">
        <img src="<?= getImagePath($settings['logo']) ?>" alt="<?= htmlspecialchars($settings['site_name']) ?> Logo" class="logo">
      </a>
    </div>
    <div class="dropdown">
      <button class="btn border-0 bg-transparent" id="profileMenu" data-bs-toggle="dropdown" aria-expanded="false">
        <i class="bi bi-person-circle fs-2"></i>
      </button>
      <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="profileMenu">
        <li><a class="dropdown-item disabled"><?= htmlspecialchars($user['name']); ?></a><hr class="dropdown-divider"></li>
        <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
        <li><a class="dropdown-item" href="subscription.php"><i class="bi bi-credit-card me-2"></i>Subscription</a></li>
        <li><hr class="dropdown-divider"></li>
        <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
      </ul>
    </div>
  </div>
</header>
    <a href="student-corner.php" class="btn btn-light text-primary" style="padding:6px 15px;">
    ← Back
</a>
<!-- Subscription Card -->
<div class="container my-5">
  <div class="card plan-card shadow-sm mx-auto text-center" style="max-width: 500px;">
    <div class="card-header <?= $headerClass; ?> py-4 fs-5 fw-semibold">
      <?= $headerText; ?>
    </div>

    <?php 
      // Ensure variables exist
      $today = new DateTime();
      $expiry = isset($userSub['sub_expiry']) ? new DateTime($userSub['sub_expiry']) : null;

      // Conditions
      $isSubscribed = ($user['status'] === 'subscribed' && $userSub && $expiry && $expiry >= $today);
    ?>

    <?php if (!$isSubscribed): ?>
      <!-- ðŸ”¹ Not Subscribed / Expired Plan -->
      <div class="card-body text-center p-4">
        <h5 class="fw-bold mb-2"><?= htmlspecialchars($plan['type']) ?></h5>
        <p class="text-muted mb-2">₹ <?= number_format($plan['amount'], 2) ?> / <?= htmlspecialchars($plan['duration']) ?></p>

        <div class="text-start mb-3">
          <?= $plan['features_html']; ?>
        </div>
         <input type="hidden" id="sub_amount" name="sub_amount" value="<?= number_format($plan['amount'], 2) ?>">
        <p class="text-muted">Subscription Validity: <?= htmlspecialchars($plan['duration']); ?></p>

<button onclick="payNow()" class="btn btn-primary">
  Buy Subscription
</button>




<script>
function payNow() {
    let amount = parseFloat(document.getElementById("sub_amount").value);

    fetch("create-order.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "amount=" + amount
    })
    .then(res => res.json())
    .then(data => {

        if (!data.order_id) {
            alert("Order creation failed!");
            return;
        }

        let options = {
            key: "<?= $settings['api_id']; ?>",
            amount: amount * 100,
            currency: "INR",
            name: "<?= $settings['site_name']; ?>",
            description: "Subscription",
            order_id: data.order_id,

            prefill: {
                email: "",
                contact: ""
            },

            handler: function (response) {

    fetch("verify-payment.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(response)
    })
    .then(res => res.text()) // <-- TEMP
    .then(txt => {

        console.log("RAW RESPONSE:", txt);  // <-- CHECK THIS

        let data = {};
        try { data = JSON.parse(txt); } 
        catch (e) { alert("Invalid JSON: " + txt); return; }

        if (data.status === "success") {
            window.location.href = "subscription-success.php";
        } else {
            alert("Verification failed: " + data.msg);
        }
    });
}

        };

        let rzp = new Razorpay(options);
        rzp.open();
    })
    .catch(err => alert("Error: " + err));
}

</script>


      </div>

    <?php else: ?>
      <!-- ðŸŸ¢ Subscribed Plan -->
      <div class="card-body text-center p-4">
        <h5 class="fw-bold text-success mb-3"><?= htmlspecialchars($plan['type']) ?></h5>
        <p class="mb-1"><strong>Plan:</strong> <?= htmlspecialchars($userSub['type']); ?></p>
        <p class="mb-1"><strong>Amount Paid:</strong>₹ <?= htmlspecialchars($userSub['amount']); ?></p>
        <p class="mb-1"><strong>Subscribed On:</strong> <?= htmlspecialchars($userSub['sub_date']); ?></p>
        <p class="mb-0"><strong>Valid Till:</strong> <?= htmlspecialchars($userSub['sub_expiry']); ?></p>
      </div>
    <?php endif; ?>
  </div>
</div>



<!-- Footer -->
<footer>
  <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
    <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
      <?= htmlspecialchars($settings['developer']); ?>
    </a>
  </p>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
