<?php
// ===========================
// unsubscribe-action.php
// ===========================

include('config.php'); // Change this path as per your project (e.g. ../config.php)
session_start();

// Step 1: Validate POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die("<h2 style='text-align:center;margin-top:50px;'>Invalid request method.</h2>");
}

$email = $_POST['email'] ?? '';
$token = $_POST['token'] ?? '';

if (empty($email) || empty($token)) {
    http_response_code(400);
    die("<h2 style='text-align:center;margin-top:50px;'>Missing parameters.</h2>");
}

// Step 2: Verify user and token
$stmt = $conn->prepare("SELECT * FROM newsletter WHERE email = ? AND unsubscribe_token = ? AND deleted_at IS NULL LIMIT 1");
$stmt->bind_param("ss", $email, $token);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(403);
    die("<h2 style='text-align:center;margin-top:50px;'>Invalid or expired unsubscribe token.</h2>");
}

$user = $result->fetch_assoc();

// Step 3: Update status to Unsubscribed and clear token
$update = $conn->prepare("UPDATE newsletter SET status = 'Unsubscribed', unsubscribe_token = NULL, updated_at = NOW() WHERE id = ?");
$update->bind_param("i", $user['id']);
$updateSuccess = $update->execute();

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Unsubscribed Successfully</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="admin/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-family: "Poppins", sans-serif;
    }
    .unsubscribe-card {
      max-width: 480px;
      margin: 120px auto;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
      padding: 40px;
      text-align: center;
    }
    .unsubscribe-card h2 {
      font-size: 24px;
      font-weight: 600;
      margin-bottom: 15px;
    }
    .unsubscribe-card p {
      color: #555;
      margin-bottom: 25px;
    }
    .btn-primary {
      background: #007bff;
      border: none;
    }
    .btn-primary:hover {
      background: #0069d9;
    }
  </style>
</head>
<body>

<div class="unsubscribe-card">
<?php if ($updateSuccess): ?>
  <h2>You've Been Unsubscribed</h2>
  <p>We're sorry to see you go, <strong><?= htmlspecialchars($email); ?></strong>.</p>
  <p>If this was a mistake, you can re-subscribe anytime from our website.</p>
  <a href="index.php" class="btn btn-primary px-4">Return to Homepage</a>
<?php else: ?>
  <h2>Something Went Wrong</h2>
  <p>We couldn’t complete your unsubscribe request. Please try again later.</p>
  <a href="index.php" class="btn btn-primary px-4">Return to Homepage</a>
<?php endif; ?>
</div>

</body>
</html>
