<?php
// ===========================
// unsubscribe.php
// ===========================

include('config.php'); // <-- change this to your actual DB connection file (e.g. conn.php)
session_start();

// --- Step 1: Get and validate parameters ---
$email = $_GET['email'] ?? '';
$token = $_GET['token'] ?? '';

if (empty($email) || empty($token)) {
    http_response_code(400);
    die("<h2 style='text-align:center; margin-top:50px;'>Invalid unsubscribe link.</h2>");
}

// --- Step 2: Securely validate email & token ---
$stmt = $conn->prepare("SELECT * FROM newsletter WHERE email = ? AND unsubscribe_token = ? AND deleted_at IS NULL LIMIT 1");
$stmt->bind_param("ss", $email, $token);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(403);
    die("<h2 style='text-align:center; margin-top:50px;'>Invalid or expired unsubscribe link.</h2>");
}

$user = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Confirm Unsubscribe</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="admin/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-family: "Poppins", sans-serif;
    }
    .unsubscribe-card {
      max-width: 480px;
      margin: 120px auto;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
      padding: 40px;
      text-align: center;
    }
    .unsubscribe-card h2 {
      font-size: 24px;
      font-weight: 600;
      margin-bottom: 15px;
    }
    .unsubscribe-card p {
      color: #555;
      margin-bottom: 25px;
    }
    .btn-danger {
      background: #dc3545;
      border: none;
    }
    .btn-danger:hover {
      background: #c82333;
    }
  </style>
</head>
<body>

<div class="unsubscribe-card">
  <h2>Confirm Unsubscribe</h2>
  <p>
    Hello <strong><?= htmlspecialchars($user['email']); ?></strong>,<br>
    Are you sure you want to unsubscribe from our newsletter?
  </p>

  <form action="unsubscribe-action.php" method="POST">
    <input type="hidden" name="email" value="<?= htmlspecialchars($user['email']); ?>">
    <input type="hidden" name="token" value="<?= htmlspecialchars($user['unsubscribe_token']); ?>">
    <button type="submit" name="confirm" class="btn btn-danger px-4">Yes, Unsubscribe</button>
    <a href="index.php" class="btn btn-secondary px-4 ms-2">Cancel</a>
  </form>
</div>

</body>
</html>
